/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.jet.stat.Probability;

public class SimpleLinearRegression {
    private double[] x;
    private double[] y;
    private double slope;
    private double intercept;
    double R2;
    double seSlope;
    double seIntercept;

    public static void main(String[] args) {
        double[] x = new double[]{38.0, 56.0, 59.0, 64.0, 74.0};
        double[] y = new double[]{41.0, 63.0, 70.0, 72.0, 84.0};
        SimpleLinearRegression lr = new SimpleLinearRegression(x, y);
        lr.compute();
        System.out.println(lr.getRoundedModel());
        System.out.println(lr.waldTestSlopeP());
        System.out.println("calculate y given an x of 38 " + lr.calculateY(38.0));
        System.out.println("calculate x given a y of 41 " + lr.calculateX(41.0));
    }

    public SimpleLinearRegression() {
    }

    public double[] getY() {
        return this.y;
    }

    public void setY(double[] y) {
        this.y = y;
    }

    public void setX(double[] x) {
        this.x = x;
    }

    public SimpleLinearRegression(double[] x, double[] y) {
        this.x = x;
        this.y = y;
    }

    public void compute() {
        int n = this.x.length;
        double sumy = 0.0;
        double sumx = 0.0;
        double sumx2 = 0.0;
        for (int i = 0; i < n; ++i) {
            sumx += this.x[i];
            sumx2 += this.x[i] * this.x[i];
            sumy += this.y[i];
        }
        double xbar = sumx / (double)n;
        double ybar = sumy / (double)n;
        double xxbar = 0.0;
        double yybar = 0.0;
        double xybar = 0.0;
        for (int i = 0; i < n; ++i) {
            xxbar += (this.x[i] - xbar) * (this.x[i] - xbar);
            yybar += (this.y[i] - ybar) * (this.y[i] - ybar);
            xybar += (this.x[i] - xbar) * (this.y[i] - ybar);
        }
        this.slope = xybar / xxbar;
        this.intercept = ybar - this.slope * xbar;
        int df = n - 2;
        double rss = 0.0;
        double ssr = 0.0;
        for (int i = 0; i < n; ++i) {
            double fit = this.slope * this.x[i] + this.intercept;
            rss += (fit - this.y[i]) * (fit - this.y[i]);
            ssr += (fit - ybar) * (fit - ybar);
        }
        this.R2 = ssr / yybar;
        double svar = rss / (double)df;
        this.seSlope = svar / xxbar;
        this.seIntercept = svar / (double)n + xbar * xbar * this.seSlope;
        this.seSlope = Math.sqrt(this.seSlope);
        this.seIntercept = Math.sqrt(this.seIntercept);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("beta_0 = " + this.intercept + " SE = " + this.seIntercept + " p = " + Probability.chiSquareComplemented(1.0, this.intercept * this.intercept / this.seIntercept / this.seIntercept));
        sb.append("\n");
        sb.append("beta_1 = " + this.slope + " SE = " + this.seSlope + " p = " + Probability.chiSquareComplemented(1.0, this.slope * this.slope / this.seSlope / this.seSlope));
        sb.append("\n");
        sb.append("R^2                 = " + this.R2);
        return sb.toString();
    }

    public double waldTestSlopeP() {
        double s = this.slope / this.seSlope;
        return Probability.chiSquareComplemented(1.0, s * s);
    }

    public double waldTestSlopeZ() {
        double s = this.slope / this.seSlope;
        return s;
    }

    public double getSlopeSE() {
        return this.seSlope;
    }

    public double getSlope() {
        return this.slope;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double getRSquared() {
        return this.R2;
    }

    public double[] getX() {
        return this.x;
    }

    public String getModel() {
        return "Y= " + this.slope + "X + " + this.intercept + " RSqrd=" + this.getRSquared();
    }

    public String getRoundedModel() {
        return "Y= " + String.format("%.3f", this.slope) + "X + " + String.format("%.3f", this.intercept) + " RSqrd=" + String.format("%.3f", this.getRSquared());
    }

    public double calculateY(double x) {
        return this.slope * x + this.intercept;
    }

    public double calculateX(double y) {
        return (y - this.intercept) / this.slope;
    }

    public void nullArrays() {
        this.x = null;
        this.y = null;
    }
}

