/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class SpearmanRankCorrelation {
    public static void main(String[] args) {
        double[] X2 = new double[]{1.0, 2.0, 3.0, 4.5, 5.0, 6.0, 7.0, 8.0, 9.0, 100.0};
        double[] Y = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        System.out.format("%.3f", SpearmanRankCorrelation.spearman(X2, Y));
    }

    static void shuffleArray(int[] ar) {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int i = ar.length - 1; i > 0; --i) {
            int index = ((Random)rnd).nextInt(i + 1);
            int a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    public static double spearman(double[] X2, double[] Y) {
        double[] Y1;
        double[] X1;
        if (X2 == null || Y == null || X2.length != Y.length) {
            return 0.0;
        }
        int n = X2.length;
        int maxN = 100000000;
        if (n > maxN) {
            int i;
            int[] ids = new int[n];
            for (int i2 = 0; i2 < n; ++i2) {
                ids[i2] = i2;
            }
            MersenneTwister tm = new MersenneTwister(new Date());
            Uniform um = new Uniform(tm);
            for (i = n - 1; i > 0; --i) {
                int index = um.nextIntFromTo(0, i);
                int a = ids[index];
                ids[index] = ids[i];
                ids[i] = a;
            }
            X1 = new double[maxN];
            Y1 = new double[maxN];
            for (i = 0; i < maxN; ++i) {
                X1[i] = X2[ids[i]];
                Y1[i] = Y[ids[i]];
            }
        } else {
            X1 = X2;
            Y1 = Y;
        }
        int[] rankX = SpearmanRankCorrelation.getRanks(X1);
        int[] rankY = SpearmanRankCorrelation.getRanks(Y1);
        n = X1.length;
        double squaretN = Math.sqrt(n) * Math.sqrt(n - 1) * Math.sqrt(n + 1);
        double numerator = 0.0;
        for (int i = 0; i < n; ++i) {
            numerator += Math.pow((double)(rankX[i] - rankY[i]) / squaretN, 2.0);
        }
        return 1.0 - (numerator *= 6.0);
    }

    private static int[] getRanks(double[] array) {
        int n = array.length;
        Pair[] pair = new Pair[n];
        for (int i = 0; i < n; ++i) {
            pair[i] = new Pair(i, array[i]);
        }
        Arrays.sort(pair, new PairValueComparator());
        int[] ranks = new int[n];
        int rank = 1;
        for (Pair p : pair) {
            ranks[p.index] = rank++;
        }
        return ranks;
    }

    private static class PairValueComparator
    implements Comparator<Pair> {
        private PairValueComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            if (p1.value < p2.value) {
                return -1;
            }
            if (p1.value > p2.value) {
                return 1;
            }
            return 0;
        }
    }

    private static class Pair {
        public final int index;
        public final double value;

        public Pair(int i, double v) {
            this.index = i;
            this.value = v;
        }
    }
}

