/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import cern.jet.stat.Gamma;
import cern.jet.stat.Probability;
import edu.sysu.pmglab.container.list.DoubleList;

public class Summary {
    public static double pValue2ChiSquare(double pValue) {
        double z = 0.0;
        if (Double.isNaN(pValue /= 2.0)) {
            return z;
        }
        z = pValue;
        if (z > 0.5) {
            if ((z = 1.0 - z) < 9.9E-324) {
                z = 9.9E-324;
            }
            z = Probability.normalInverse(z);
        } else {
            if (z < 9.9E-324) {
                z = 9.9E-324;
            }
            z = Probability.normalInverse(z);
        }
        return z * z;
    }

    public static double adjustPValueByGC(double pValue, double gcValue) {
        double z = 0.0;
        if (Double.isNaN(pValue /= 2.0)) {
            return z;
        }
        z = pValue;
        if (z > 0.5) {
            if ((z = 1.0 - z) < 9.9E-324) {
                z = 9.9E-324;
            }
            z = Probability.normalInverse(z);
        } else {
            if (z < 9.9E-324) {
                z = 9.9E-324;
            }
            z = Probability.normalInverse(z);
        }
        double chi = z * z / gcValue;
        return Probability.chiSquareComplemented(1.0, chi);
    }

    double mean(DoubleList vars) {
        double vale = 0.0;
        int size = vars.size();
        for (int i = 0; i < size; ++i) {
            vale += vars.get(i);
        }
        return vale / (double)size;
    }

    double var(DoubleList vars) {
        double var = 0.0;
        double mean = this.mean(vars);
        int size = vars.size();
        for (int i = 0; i < size; ++i) {
            double val = vars.get(i) - mean;
            val *= val;
            var += val;
        }
        return var / (double)(size - 1);
    }

    double sd(DoubleList vars) {
        double var = 0.0;
        double mean = this.mean(vars);
        int size = vars.size();
        for (int i = 0; i < size; ++i) {
            double val = vars.get(i) - mean;
            val *= val;
            var += val;
        }
        return Math.sqrt(var / (double)(size - 1));
    }

    private static double sum(double[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (Double.isNaN(a[i])) continue;
            sum += a[i];
        }
        return sum;
    }

    public static void standWeight(double[] weight) {
        double sumW = Summary.sum(weight);
        for (int i = 0; i < weight.length; ++i) {
            weight[i] = weight[i] / sumW;
        }
    }

    public static double stddev(double[] a, double[] weight) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double avg = Summary.mean(a, weight, false);
        double v2 = 0.0;
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            if (Double.isNaN(a[i])) continue;
            v2 += weight[i] * weight[i];
            sum += (a[i] - avg) * (a[i] - avg) * weight[i];
        }
        return Math.sqrt(sum / (1.0 - v2));
    }

    public static double mean(double[] a, double[] weight, boolean standizeWeight) {
        int i;
        if (a.length == 0) {
            return Double.NaN;
        }
        if (standizeWeight) {
            double sumW = Summary.sum(weight);
            for (i = 0; i < weight.length; ++i) {
                weight[i] = weight[i] / sumW;
            }
        }
        double mean = 0.0;
        for (i = 0; i < weight.length; ++i) {
            if (Double.isNaN(a[i])) continue;
            mean += weight[i] * a[i];
        }
        return mean;
    }

    public static double stddevNadw(double[] a, double[] weight) {
        if (a.length == 0) {
            return Double.NaN;
        }
        double[] newW = new double[weight.length];
        System.arraycopy(weight, 0, newW, 0, weight.length);
        double avg = Summary.mean(a, newW, true);
        double v2 = 0.0;
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            v2 += newW[i] * newW[i];
            sum += (a[i] - avg) * (a[i] - avg) * newW[i];
        }
        return Math.sqrt(sum / (1.0 - v2));
    }

    public static double mean(double[] vars) {
        double vale = 0.0;
        int size = vars.length;
        int num = 0;
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(vars[i])) continue;
            vale += vars[i];
            ++num;
        }
        return vale / (double)num;
    }

    public static double mean(float[] vars) {
        double vale = 0.0;
        int size = vars.length;
        int num = 0;
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(vars[i])) continue;
            vale += (double)vars[i];
            ++num;
        }
        return vale / (double)num;
    }

    public static double var(double[] vars) {
        double var = 0.0;
        double mean = Summary.mean(vars);
        int size = vars.length;
        for (int i = 0; i < size; ++i) {
            double val = vars[i] - mean;
            val *= val;
            var += val;
        }
        return var / (double)(size - 1);
    }

    public static double sd(double[] vars) {
        double var = 0.0;
        double mean = Summary.mean(vars);
        int size = vars.length;
        for (int i = 0; i < size; ++i) {
            double val = vars[i] - mean;
            val *= val;
            var += val;
        }
        return Math.sqrt(var / (double)(size - 1));
    }

    public static double stddev(double[] vars, double mean) {
        double var = 0.0;
        int size = vars.length;
        int num = 0;
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(vars[i])) continue;
            double val = vars[i] - mean;
            val *= val;
            var += val;
            ++num;
        }
        var = Math.sqrt(var / (double)(num - 1));
        return var;
    }

    public static double stddev(float[] vars, double mean) {
        double var = 0.0;
        int size = vars.length;
        int num = 0;
        for (int i = 0; i < size; ++i) {
            if (Double.isNaN(vars[i])) continue;
            double val = (double)vars[i] - mean;
            val *= val;
            var += val;
            ++num;
        }
        var = Math.sqrt(var / (double)(num - 1));
        return var;
    }

    public static double benjaminiHochbergFDR(double fdrThreshold, double[] sp) {
        int i;
        int ti = sp.length;
        if (ti == 0) {
            return fdrThreshold;
        }
        double[] pv_BH = new double[ti];
        double t = ti;
        pv_BH[ti - 1] = sp[ti - 1];
        double x = 0.0;
        for (i = ti - 2; i >= 0; --i) {
            x = t / (double)(i + 1) * sp[i] < 1.0 ? t / (double)(i + 1) * sp[i] : 1.0;
            pv_BH[i] = pv_BH[i + 1] < x ? pv_BH[i + 1] : x;
        }
        if (pv_BH[0] <= fdrThreshold) {
            for (i = 1; i < ti; ++i) {
                if (!(pv_BH[i] >= fdrThreshold)) continue;
                return sp[i - 1];
            }
        }
        return fdrThreshold / (double)ti;
    }

    public static double MLFC(double fdrThreshold, double[] sp) {
        int total = sp.length;
        if (total == 0) {
            return fdrThreshold;
        }
        int start = 0;
        double sum = 0.0;
        while (!Double.isNaN(sp[start]) && sp[start] <= fdrThreshold) {
            ++start;
        }
        double effTotal = total - start;
        int effecNum = 0;
        int stopIndex = (int)(effTotal / 4.0);
        while (start < total) {
            if (!Double.isNaN(sp[start])) {
                double ratio = sp[start] / ((double)(effecNum + 1) / (effTotal + 1.0));
                sum += Math.abs(Math.log(ratio) / Math.log(2.0));
                if (++effecNum > stopIndex) break;
            }
            ++start;
        }
        return sum / (double)effecNum;
    }

    public static double zScore(double pValue) {
        double q = 0.0;
        if (Double.isNaN(pValue)) {
            return q;
        }
        q = pValue;
        if (q > 0.5) {
            if ((q = 1.0 - q) < 9.9E-324) {
                q = 9.9E-324;
            }
            q = Probability.normalInverse(q);
            return -q;
        }
        if (q < 9.9E-324) {
            q = 9.9E-324;
        }
        q = Probability.normalInverse(q);
        return q;
    }

    public static double caculateInflationFactorDiff(double fdrThreshold, DoubleList pvalues) {
        int start = 0;
        while (!Double.isNaN(pvalues.get(start)) && pvalues.get(start) <= fdrThreshold) {
            ++start;
        }
        DoubleArrayList tmpDoubleList = new DoubleArrayList(pvalues.size() - start);
        int size = pvalues.size();
        double chiSquare = 0.0;
        for (int i = start; i < size; ++i) {
            chiSquare = Summary.zScore(pvalues.get(i) / 2.0);
            chiSquare *= chiSquare;
            tmpDoubleList.add(chiSquare);
        }
        tmpDoubleList.quickSort();
        double quant = 0.5;
        double chi = 0.4549364;
        quant = 0.75;
        chi = 1.323304;
        double median = Descriptive.quantile(tmpDoubleList, quant);
        tmpDoubleList.clear();
        tmpDoubleList.clear();
        return Math.abs(median - 1.0);
    }

    public static double MLFC(double fdrThreshold, DoubleList sp) {
        int total = sp.size();
        if (total == 0) {
            return fdrThreshold;
        }
        int start = 0;
        double sum = 0.0;
        while (!Double.isNaN(sp.get(start)) && sp.get(start) <= fdrThreshold) {
            ++start;
        }
        double effTotal = total - start;
        int effecNum = 0;
        int stopIndex = (int)(effTotal / 4.0);
        while (start < total) {
            if (!Double.isNaN(sp.get(start))) {
                double ratio = sp.get(start) / ((double)(effecNum + 1) / (effTotal + 1.0));
                sum += Math.abs(Math.log(ratio) / Math.log(2.0));
                if (++effecNum > stopIndex) break;
            }
            ++start;
        }
        return sum / (double)effecNum;
    }

    public static double benjaminiHochbergFDR(double fdrThreshold, DoubleList sp) {
        int i;
        int ti = sp.size();
        if (ti == 0) {
            return fdrThreshold;
        }
        double[] pv_BH = new double[ti];
        double t = ti;
        pv_BH[ti - 1] = sp.get(ti - 1);
        double x = 0.0;
        for (i = ti - 2; i >= 0; --i) {
            x = t / (double)(i + 1) * sp.get(i) < 1.0 ? t / (double)(i + 1) * sp.get(i) : 1.0;
            pv_BH[i] = pv_BH[i + 1] < x ? pv_BH[i + 1] : x;
        }
        if (pv_BH[0] <= fdrThreshold) {
            for (i = 1; i < ti; ++i) {
                if (!(pv_BH[i] >= fdrThreshold)) continue;
                return sp.get(i - 1);
            }
        }
        return fdrThreshold / (double)ti;
    }

    public static double benjaminiHochbergFDR(double fdrThreshold, DoubleArrayList sp, DoubleArrayList adjustedP) {
        int i;
        int ti = sp.size();
        if (ti == 0) {
            return fdrThreshold;
        }
        adjustedP.setSize(ti);
        double[] pv_BH = new double[ti];
        double t = ti;
        pv_BH[ti - 1] = sp.getQuick(ti - 1);
        adjustedP.setQuick(ti - 1, pv_BH[ti - 1]);
        double x = 0.0;
        for (i = ti - 2; i >= 0; --i) {
            x = t / (double)(i + 1) * sp.getQuick(i) < 1.0 ? t / (double)(i + 1) * sp.getQuick(i) : 1.0;
            pv_BH[i] = pv_BH[i + 1] < x ? pv_BH[i + 1] : x;
            adjustedP.setQuick(i, pv_BH[i]);
        }
        if (pv_BH[0] <= fdrThreshold) {
            for (i = 1; i < ti; ++i) {
                if (!(pv_BH[i] >= fdrThreshold)) continue;
                return sp.getQuick(i - 1);
            }
        }
        return fdrThreshold / (double)ti;
    }

    public static double calculateFPValue(double F, int d1, int d2) {
        double v = (double)d1 * F / ((double)d1 * F + (double)d2);
        double a = (double)d1 / 2.0;
        double b = (double)d2 / 2.0;
        double cumulativeProbability = Gamma.incompleteBeta(a, b, v);
        return 1.0 - cumulativeProbability;
    }
}

