/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.stat;

public enum ThresholdRegressionR {
    INSTANCE;

    public String doubleThresholdsLinearDavies = "# 0. \u8f85\u52a9\u51fd\u6570\uff1a\u8ba1\u7b97\u6307\u793a\u53d8\u91cf I (\u4fdd\u6301\u4e0d\u53d8)\ncalculate_indicator <- function(X_matrix, c_val, d_val) {\n  if (is.null(X_matrix) || ncol(X_matrix) == 0 || is.na(c_val) || is.na(d_val)) {\n    return(numeric(0))\n  }\n  counts_ge_c <- rowSums(X_matrix >= c_val, na.rm = TRUE)\n  indicator <- as.numeric(counts_ge_c >= d_val)\n  return(indicator)\n}\n\n\n# 1. \u51fd\u6570\uff1a\u5bf9\u7ed9\u5b9a\u7684 (c,d) \u8ba1\u7b97 F \u7edf\u8ba1\u91cf (\u6216 t^2) for k\nget_f_statistic_for_k <- function(Y, X_matrix, Z_matrix = NULL, c_val, d_val, n_obs) {\n  if (is.null(X_matrix) || ncol(X_matrix) == 0) return(0)\n  \n  I_cd_vec <- calculate_indicator(X_matrix, c_val, d_val)\n  if (length(I_cd_vec) == 0 && n_obs > 0) I_cd_vec <- rep(0, n_obs)\n  if (length(I_cd_vec) != n_obs && n_obs > 0) {\n    if(length(I_cd_vec)>0) I_cd_vec <- rep(I_cd_vec[1],n_obs) else I_cd_vec <- rep(0,n_obs)\n  }\n  \n  if (length(unique(I_cd_vec)) < 2) { # If indicator is constant, k is not identifiable / F is 0\n    return(0)\n  }\n  \n  df_model <- data.frame(Y_target = Y, I_threshold = I_cd_vec)\n  formula_str <- \"Y_target ~ I_threshold\"\n  \n  z_names_global <- NULL\n  if (!is.null(Z_matrix) && ncol(Z_matrix) > 0) {\n    if(is.null(colnames(Z_matrix))) {\n      z_names_global <- paste0(\"Z_dt_\", 1:ncol(Z_matrix)) # Unique names for this context\n      colnames(Z_matrix) <- z_names_global\n    } else {\n      z_names_global <- colnames(Z_matrix)\n    }\n    df_model <- cbind(df_model, as.data.frame(Z_matrix))\n    formula_str <- paste(formula_str, \"+\", paste(z_names_global, collapse = \" + \"))\n  }\n  \n  fit <- tryCatch(lm(as.formula(formula_str), data = df_model), error = function(e) NULL)\n  \n  if (is.null(fit) || !\"I_threshold\" %in% names(coef(fit))) {\n    return(0)\n  }\n  \n  summary_fit <- summary(fit)\n  if (\"I_threshold\" %in% rownames(summary_fit$coefficients)) {\n    t_value_k <- summary_fit$coefficients[\"I_threshold\", \"t value\"]\n    return(t_value_k^2) # F(1, df_error) = t^2\n  } else {\n    return(0)\n  }\n}\n\n\n# 2. \u4e3b\u51fd\u6570\uff1a\u5c1d\u8bd5\u5e94\u7528 Davies' Test \u8fd1\u4f3c\nestimate_davies_like_test <- function(Y, X_matrix, Z_matrix = NULL,\n                                      c_candidates, d_candidates, n_obs) {\n  \n  m_dim_X <- if (!is.null(X_matrix)) ncol(X_matrix) else 0\n  if (m_dim_X == 0) {\n    # Fit model without X and return basic stats, Davies test not applicable\n    df_base_noX <- data.frame(Y=Y)\n    formula_noX <- \"Y ~ 1\"\n    if (!is.null(Z_matrix) && ncol(Z_matrix) > 0) {\n      if(is.null(colnames(Z_matrix))) colnames(Z_matrix) <- paste0(\"Z\", 1:ncol(Z_matrix))\n      df_base_noX <- cbind(df_base_noX, as.data.frame(Z_matrix))\n      formula_noX <- paste(\"Y ~\", paste(colnames(Z_matrix), collapse=\" + \"))\n    }\n    model_noX <- lm(as.formula(formula_noX), data=df_base_noX)\n    return(list(\n      davies_p_upper_bound = 1.0, sup_F_statistic = 0,\n      best_c = NA, best_d = NA,\n      nominal_p_value_at_sup_F = 1.0,\n      V_approx = 0,\n      final_model_summary = summary(model_noX)\n    ))\n  }\n  \n  \n  # --- Step 1: Find sup F(c,d) ---\n  sup_F <- 0\n  best_c_for_sup_F <- NA\n  best_d_for_sup_F <- NA\n  \n  # Store all F-statistics for V calculation\n  all_F_stats <- array(0, dim = c(length(c_candidates), length(d_candidates)))\n  dimnames(all_F_stats) <- list(format(c_candidates, digits=4), as.character(d_candidates))\n  \n  \n  cat(\"Calculating F-statistics over the grid (for sup F and V_approx)...\\n\")\n  pb_grid <- txtProgressBar(min = 0, max = length(d_candidates) * length(c_candidates), style = 3)\n  iter_count <- 0\n  \n  for (j_d in seq_along(d_candidates)) {\n    d_val <- d_candidates[j_d]\n    for (i_c in seq_along(c_candidates)) {\n      c_val <- c_candidates[i_c]\n      iter_count <- iter_count + 1\n      \n      current_F <- get_f_statistic_for_k(Y, X_matrix, Z_matrix, c_val, d_val, n_obs)\n      all_F_stats[i_c, j_d] <- current_F\n      \n      if (current_F > sup_F) {\n        sup_F <- current_F\n        best_c_for_sup_F <- c_val\n        best_d_for_sup_F <- d_val\n      }\n      setTxtProgressBar(pb_grid, iter_count)\n    }\n  }\n  close(pb_grid)\n  \n  if (sup_F < 1e-6) { # If no effect found anywhere\n    cat(\"Sup F statistic is very close to zero. No threshold effect detected by this measure.\\n\")\n    # Fit reduced model for summary\n    df_base_reduced <- data.frame(Y=Y)\n    formula_reduced <- \"Y ~ 1\"\n    if (!is.null(Z_matrix) && ncol(Z_matrix) > 0) {\n      if(is.null(colnames(Z_matrix))) colnames(Z_matrix) <- paste0(\"Z\", 1:ncol(Z_matrix))\n      df_base_reduced <- cbind(df_base_reduced, as.data.frame(Z_matrix))\n      formula_reduced <- paste(\"Y ~\", paste(colnames(Z_matrix), collapse=\" + \"))\n    }\n    model_reduced <- lm(as.formula(formula_reduced), data=df_base_reduced)\n    return(list(\n      davies_p_upper_bound = 1.0, sup_F_statistic = sup_F,\n      best_c = best_c_for_sup_F, best_d = best_d_for_sup_F,\n      nominal_p_value_at_sup_F = 1.0,\n      V_approx = 0,\n      final_model_summary = summary(model_reduced)\n    ))\n  }\n  \n  # Nominal p-value at sup_F (df1=1 for k)\n  # Get df_error from the model at sup_F\n  I_best <- calculate_indicator(X_matrix, best_c_for_sup_F, best_d_for_sup_F)\n  df_model_at_sup <- data.frame(Y=Y, I_threshold=I_best)\n  formula_at_sup <- \"Y ~ I_threshold\"\n  if (!is.null(Z_matrix) && ncol(Z_matrix) > 0) {\n    if(is.null(colnames(Z_matrix))) colnames(Z_matrix) <- paste0(\"Z\", 1:ncol(Z_matrix)) # Ensure colnames\n    df_model_at_sup <- cbind(df_model_at_sup, as.data.frame(Z_matrix))\n    formula_at_sup <- paste(formula_at_sup, \"+\", paste(colnames(Z_matrix), collapse=\" + \"))\n  }\n  fit_at_sup <- lm(as.formula(formula_at_sup), data=df_model_at_sup)\n  df_error <- df.residual(fit_at_sup)\n  \n  nominal_p_at_sup_F <- pf(sup_F, df1 = 1, df2 = df_error, lower.tail = FALSE)\n  \n  # --- Step 2: Approximate V (total variation) ---\n  # This is a very heuristic approximation for the combined (c,d) search\n  V_approx_total <- 0\n  \n  # For each d, calculate variation over c\n  for (j_d in seq_along(d_candidates)) {\n    d_val <- d_candidates[j_d]\n    f_stats_for_d <- all_F_stats[, j_d]\n    sqrt_f_stats_for_d <- sqrt(f_stats_for_d) # Work with ~ |t-stat|\n    \n    # Sum of absolute changes in sqrt(F) along the c_candidates path for this d\n    # Exclude NAs from diff if any sqrt_f_stats were NA (e.g. from F=0)\n    changes_for_d <- abs(diff(sqrt_f_stats_for_d[!is.na(sqrt_f_stats_for_d)]))\n    V_approx_total <- V_approx_total + sum(changes_for_d, na.rm = TRUE)\n  }\n  # We might also consider changes when d changes for a fixed c, but that's harder to define a \"path\"\n  # A simpler, potentially more conservative approach for V_approx related to number of grid points:\n  # V_approx_total <- (length(c_candidates)-1) * length(d_candidates) * mean_abs_change_per_step\n  # For now, the sum over d seems like a plausible starting point for this heuristic.\n  # If V is 0 (e.g. F is always 0), the correction term will be 0.\n  if (is.na(V_approx_total) || V_approx_total < 1e-6) V_approx_total <- 0 # Avoid issues if V is tiny or NA\n  \n  \n  # --- Step 3: Calculate Davies' p-value upper bound ---\n  # Formula from Davies (1987, JRSSB, eq 4.6) or Davies (2002, Biometrika, eq 2)\n  # For q=1 (k is one-dimensional)\n  # P_upper = P(chi^2_1 >= M) + V * exp(-M/2) / sqrt(2*pi*M)  (if M > 0)\n  # Note: Davies(2002) uses M for the stat, and chi_1^2 for P(Z^2 > M).\n  # The second term in Davies (1987) is V * M^((q-1)/2) * exp(-M/2) / ( (2*pi)^((q+1)/2) * Gamma(q/2) * 2^((q-1)/2) )\n  # For q=1: Gamma(1/2) = sqrt(pi). Denom = (2*pi) * sqrt(pi) * 1 = 2*pi^(3/2) ???\n  # Let's use the simpler form from Davies (2002) which is often cited for q=1:\n  # P_upper approx P(chi^2_1 >= M) + V * exp(-M/2) / sqrt(2*pi*M)\n  # This assumes S(gamma) is approximately |N(0,1)| or sqrt(chi^2_1). Our M is F_1,df, so M ~ chi^2_1 under H0 large df.\n  \n  davies_p <- nominal_p_at_sup_F # Start with the nominal p-value\n  \n  if (sup_F > 0 && V_approx_total > 0) {\n    correction_term <- V_approx_total * exp(-sup_F / 2) / sqrt(2 * pi * sup_F)\n    davies_p <- nominal_p_at_sup_F + correction_term\n    davies_p <- min(1, davies_p) # p-value cannot exceed 1\n  }\n  \n  # Final model based on best_c_for_sup_F, best_d_for_sup_F\n  final_model_summary <- summary(fit_at_sup)\n  all_coeffs <- coef(fit_at_sup)\n  b_hat <- all_coeffs[\"(Intercept)\"]\n  \n  z_names_final <- if (!is.null(Z_matrix)) colnames(Z_matrix) else character(0) # Use potentially updated colnames\n  valid_z_names <- z_names_final[z_names_final %in% names(all_coeffs)]\n  z_hat <- all_coeffs[valid_z_names]\n  \n  k_hat_estimate <- NA\n  if (\"I_threshold\" %in% names(all_coeffs)) {\n    k_hat_estimate <- all_coeffs[\"I_threshold\"]\n  }\n  \n  \n  return(list(\n    davies_p_upper_bound = davies_p,\n    sup_F_statistic = sup_F,\n    best_c = best_c_for_sup_F,\n    best_d = best_d_for_sup_F,\n    nominal_p_value_at_sup_F = nominal_p_at_sup_F,\n    V_approx = V_approx_total,\n    df_error_at_sup_F = df_error,\n    final_model_summary = final_model_summary,\n    coefficients = list(b_hat = b_hat, k_hat = k_hat_estimate, z_hat = z_hat)\n  ))\n}";
    public String doubleThresholdsLogitDavies = "# 0. \u8f85\u52a9\u51fd\u6570\uff1a\u8ba1\u7b97\u6307\u793a\u53d8\u91cf I (\u4fdd\u6301\u4e0d\u53d8)\ncalculate_indicator <- function(X_matrix, c_val, d_val) {\n  if (is.null(X_matrix) || ncol(X_matrix) == 0 || is.na(c_val) || is.na(d_val)) {\n    return(numeric(0))\n  }\n  counts_ge_c <- rowSums(X_matrix >= c_val, na.rm = TRUE)\n  indicator <- as.numeric(counts_ge_c >= d_val)\n  return(indicator)\n}\n\n# 1. \u51fd\u6570\uff1a\u5bf9\u7ed9\u5b9a\u7684 (c,d) \u8ba1\u7b97 LRT \u7edf\u8ba1\u91cf for k (\u903b\u8f91\u56de\u5f52)\nget_lrt_statistic_for_k_logit <- function(Y, X_matrix, Z_matrix = NULL, c_val, d_val, n_obs) {\n  if (is.null(X_matrix) || ncol(X_matrix) == 0) return(0)\n  \n  I_cd_vec <- calculate_indicator(X_matrix, c_val, d_val)\n  if (length(I_cd_vec) == 0 && n_obs > 0) I_cd_vec <- rep(0, n_obs)\n  if (length(I_cd_vec) != n_obs && n_obs > 0) {\n    if(length(I_cd_vec)>0) I_cd_vec <- rep(I_cd_vec[1],n_obs) else I_cd_vec <- rep(0,n_obs)\n  }\n  \n  is_I_constant <- (length(unique(I_cd_vec)) < 2)\n  \n  df_model <- data.frame(Y_target = Y)\n  if(is_I_constant){\n    # If I is constant, no additional term for I, LRT related to k is 0\n    return(0)\n  }\n  df_model$I_threshold <- I_cd_vec # Add only if not constant\n  \n  formula_full <- \"Y_target ~ I_threshold\"\n  formula_reduced <- \"Y_target ~ 1\"\n  \n  z_names_global <- NULL\n  if (!is.null(Z_matrix) && ncol(Z_matrix) > 0) {\n    if(is.null(colnames(Z_matrix))) {\n      z_names_global <- paste0(\"Z_dt_\", 1:ncol(Z_matrix))\n      colnames(Z_matrix) <- z_names_global\n    } else {\n      z_names_global <- colnames(Z_matrix)\n    }\n    df_model <- cbind(df_model, as.data.frame(Z_matrix))\n    formula_full <- paste(formula_full, \"+\", paste(z_names_global, collapse = \" + \"))\n    formula_reduced <- paste(\"Y_target ~\", paste(z_names_global, collapse = \" + \"))\n  }\n  \n  fit_full <- tryCatch(glm(as.formula(formula_full), data = df_model, family = binomial(link = \"logit\")), error = function(e) NULL)\n  fit_reduced <- tryCatch(glm(as.formula(formula_reduced), data = df_model, family = binomial(link = \"logit\")), error = function(e) NULL)\n  \n  if (is.null(fit_full) || is.null(fit_reduced)) {\n    return(0) # Or handle error appropriately\n  }\n  \n  logLik_full <- tryCatch(as.numeric(logLik(fit_full)), error = function(e) -Inf)\n  logLik_reduced <- tryCatch(as.numeric(logLik(fit_reduced)), error = function(e) -Inf)\n  \n  if (is.infinite(logLik_full) || is.infinite(logLik_reduced) || logLik_full < logLik_reduced) {\n    return(0) # LRT should be non-negative\n  }\n  \n  lrt_stat <- 2 * (logLik_full - logLik_reduced)\n  return(max(0, lrt_stat)) # Ensure non-negative\n}\n\n\n# 2. \u4e3b\u51fd\u6570\uff1a\u5c1d\u8bd5\u5e94\u7528 Davies' Test \u8fd1\u4f3c (\u903b\u8f91\u56de\u5f52\u7248)\nestimate_logit_davies_like_test <- function(Y, X_matrix, Z_matrix = NULL,\n                                            c_candidates, d_candidates, n_obs) {\n  \n  m_dim_X <- if (!is.null(X_matrix)) ncol(X_matrix) else 0\n  if (m_dim_X == 0) {\n    df_base_noX <- data.frame(Y_target=Y)\n    formula_noX <- \"Y_target ~ 1\"\n    z_names_noX <- NULL\n    if (!is.null(Z_matrix) && ncol(Z_matrix) > 0) {\n      if(is.null(colnames(Z_matrix))) {\n        z_names_noX <- paste0(\"Z_noX_\",1:ncol(Z_matrix))\n        colnames(Z_matrix) <- z_names_noX\n      } else {\n        z_names_noX <- colnames(Z_matrix)\n      }\n      df_base_noX <- cbind(df_base_noX, as.data.frame(Z_matrix))\n      formula_noX <- paste(\"Y_target ~\", paste(z_names_noX, collapse=\" + \"))\n    }\n    model_noX <- glm(as.formula(formula_noX), data=df_base_noX, family=binomial(link=\"logit\"))\n    return(list(\n      davies_p_upper_bound = 1.0, sup_LRT_statistic = 0,\n      best_c = NA, best_d = NA,\n      nominal_p_value_at_sup_LRT = 1.0,\n      V_approx = 0,\n      final_model_summary = summary(model_noX), # Summary of reduced model\n      coefficients = list(b_hat = coef(model_noX)[\"(Intercept)\"], k_hat = 0, \n                          z_hat = if(!is.null(z_names_noX)) coef(model_noX)[z_names_noX] else NULL)\n    ))\n  }\n  \n  # --- Step 1: Find sup LRT(c,d) ---\n  sup_LRT <- 0\n  best_c_for_sup_LRT <- NA\n  best_d_for_sup_LRT <- NA\n  \n  all_LRT_stats <- array(0, dim = c(length(c_candidates), length(d_candidates)))\n  dimnames(all_LRT_stats) <- list(format(c_candidates, digits=4), as.character(d_candidates))\n  \n  cat(\"Calculating LRT statistics over the grid (for sup LRT and V_approx)...\\n\")\n  pb_grid <- txtProgressBar(min = 0, max = length(d_candidates) * length(c_candidates), style = 3)\n  iter_count <- 0\n  \n  # Ensure Z_matrix has colnames for consistent use in get_lrt_statistic_for_k_logit\n  Z_matrix_internal <- Z_matrix\n  if (!is.null(Z_matrix_internal) && is.null(colnames(Z_matrix_internal))) {\n    colnames(Z_matrix_internal) <- paste0(\"Z_param_\", 1:ncol(Z_matrix_internal))\n  }\n  \n  \n  for (j_d in seq_along(d_candidates)) {\n    d_val <- d_candidates[j_d]\n    for (i_c in seq_along(c_candidates)) {\n      c_val <- c_candidates[i_c]\n      iter_count <- iter_count + 1\n      \n      current_LRT <- get_lrt_statistic_for_k_logit(Y, X_matrix, Z_matrix_internal, c_val, d_val, n_obs)\n      all_LRT_stats[i_c, j_d] <- current_LRT\n      \n      if (current_LRT > sup_LRT) {\n        sup_LRT <- current_LRT\n        best_c_for_sup_LRT <- c_val\n        best_d_for_sup_LRT <- d_val\n      }\n      setTxtProgressBar(pb_grid, iter_count)\n    }\n  }\n  close(pb_grid)\n  \n  if (sup_LRT < 1e-6) {\n    cat(\"Sup LRT statistic is very close to zero. No threshold effect detected by this measure.\\n\")\n    # Fit reduced model for summary and coefficients\n    df_base_reduced <- data.frame(Y_target=Y)\n    formula_reduced <- \"Y_target ~ 1\"\n    z_names_reduced <- NULL\n    if (!is.null(Z_matrix_internal) && ncol(Z_matrix_internal) > 0) {\n      z_names_reduced <- colnames(Z_matrix_internal) # Use already processed colnames\n      df_base_reduced <- cbind(df_base_reduced, as.data.frame(Z_matrix_internal))\n      formula_reduced <- paste(\"Y_target ~\", paste(z_names_reduced, collapse=\" + \"))\n    }\n    model_reduced <- glm(as.formula(formula_reduced), data=df_base_reduced, family=binomial(link=\"logit\"))\n    return(list(\n      davies_p_upper_bound = 1.0, sup_LRT_statistic = sup_LRT,\n      best_c = best_c_for_sup_LRT, best_d = best_d_for_sup_LRT,\n      nominal_p_value_at_sup_LRT = 1.0,\n      V_approx = 0,\n      final_model_summary = summary(model_reduced),\n      coefficients = list(b_hat = coef(model_reduced)[\"(Intercept)\"], k_hat = 0, \n                          z_hat = if(!is.null(z_names_reduced)) coef(model_reduced)[z_names_reduced] else NULL)\n    ))\n  }\n  \n  # Nominal p-value at sup_LRT (LRT ~ chi^2_1 under H0)\n  nominal_p_at_sup_LRT <- pchisq(sup_LRT, df = 1, lower.tail = FALSE)\n  \n  # --- Step 2: Approximate V (total variation) ---\n  V_approx_total <- 0\n  for (j_d in seq_along(d_candidates)) {\n    lrt_stats_for_d <- all_LRT_stats[, j_d]\n    # Using sqrt(LRT) as it behaves more like |N(0,1)| under H0 for a single parameter\n    sqrt_lrt_stats_for_d <- sqrt(lrt_stats_for_d) \n    changes_for_d <- abs(diff(sqrt_lrt_stats_for_d[!is.na(sqrt_lrt_stats_for_d)]))\n    V_approx_total <- V_approx_total + sum(changes_for_d, na.rm = TRUE)\n  }\n  if (is.na(V_approx_total) || V_approx_total < 1e-6) V_approx_total <- 0\n  \n  # --- Step 3: Calculate Davies' p-value upper bound ---\n  davies_p <- nominal_p_at_sup_LRT\n  if (sup_LRT > 0 && V_approx_total > 0) {\n    # M = sup_LRT, q = 1\n    correction_term <- V_approx_total * exp(-sup_LRT / 2) / sqrt(2 * pi * sup_LRT)\n    davies_p <- nominal_p_at_sup_LRT + correction_term\n    davies_p <- min(1, davies_p)\n  }\n  \n  # Final model details based on best_c_for_sup_LRT, best_d_for_sup_LRT\n  I_best <- calculate_indicator(X_matrix, best_c_for_sup_LRT, best_d_for_sup_LRT)\n  df_model_at_sup <- data.frame(Y_target=Y) # Renamed to Y_target for consistency\n  \n  # Important: Use I_best only if it's not constant for the final model\n  is_I_best_final_constant <- (length(unique(I_best)) < 2)\n  formula_at_sup <- \"Y_target ~ 1\" # Base formula\n  \n  if (!is_I_best_final_constant) {\n    df_model_at_sup$I_threshold <- I_best # Add if not constant\n    formula_at_sup <- \"Y_target ~ I_threshold\"\n  }\n  \n  if (!is.null(Z_matrix_internal) && ncol(Z_matrix_internal) > 0) {\n    df_model_at_sup <- cbind(df_model_at_sup, as.data.frame(Z_matrix_internal))\n    z_cols_str <- paste(colnames(Z_matrix_internal), collapse=\" + \")\n    if (formula_at_sup == \"Y_target ~ 1\") { # If I_threshold was not added\n      formula_at_sup <- paste(\"Y_target ~\", z_cols_str)\n    } else {\n      formula_at_sup <- paste(formula_at_sup, \"+\", z_cols_str)\n    }\n  }\n  fit_at_sup <- glm(as.formula(formula_at_sup), data=df_model_at_sup, family=binomial(link=\"logit\"))\n  final_model_summary <- summary(fit_at_sup)\n  all_coeffs <- coef(fit_at_sup)\n  \n  b_hat <- all_coeffs[\"(Intercept)\"]\n  k_hat_estimate <- if (!is_I_best_final_constant && \"I_threshold\" %in% names(all_coeffs)) all_coeffs[\"I_threshold\"] else 0\n  \n  z_names_final <- if (!is.null(Z_matrix_internal)) colnames(Z_matrix_internal) else character(0)\n  valid_z_names <- z_names_final[z_names_final %in% names(all_coeffs)]\n  z_hat <- all_coeffs[valid_z_names]\n  \n  return(list(\n    davies_p_upper_bound = davies_p,\n    sup_LRT_statistic = sup_LRT,\n    best_c = best_c_for_sup_LRT,\n    best_d = best_d_for_sup_LRT,\n    nominal_p_value_at_sup_LRT = nominal_p_at_sup_LRT,\n    V_approx = V_approx_total,\n    final_model_summary = final_model_summary,\n    coefficients = list(b_hat = b_hat, k_hat = k_hat_estimate, z_hat = z_hat)\n  ))\n}\n";
}

