/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.text;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum Utility {
    INSTANCE;


    private static int levenshteinDistance(String a, String b) {
        int[][] dp = new int[a.length() + 1][b.length() + 1];
        for (int i = 0; i <= a.length(); ++i) {
            for (int j = 0; j <= b.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + (a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1)));
            }
        }
        return dp[a.length()][b.length()];
    }

    public static List<String> top3Matches(Set<String> candidates, String name) {
        return candidates.stream().sorted(Comparator.comparingInt(s -> Utility.levenshteinDistance(name, s))).limit(3L).collect(Collectors.toList());
    }

    public static boolean hasSignLineHead(LiveFile liveFile, String[] headStartLine) throws IOException {
        ReaderStream readerStream = liveFile.openAsText();
        boolean hasSign = false;
        String startIndex = null;
        ByteStream cache = new ByteStream();
        while (readerStream.readline(cache) != -1) {
            Bytes line = cache.toBytes();
            if (line.byteAt(0) == 35) {
                if (line.byteAt(1) != 35) {
                    hasSign = true;
                    break;
                }
            } else {
                startIndex = line.subBytes(0, 10).toString();
                break;
            }
            cache.clear();
        }
        readerStream.close();
        headStartLine[0] = startIndex;
        return hasSign;
    }
}

