/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

public final class Assert {
    private Assert() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static void that(boolean condition) {
        if (!condition) {
            throw new AssertionError();
        }
    }

    public static void that(boolean condition, String message) {
        if (!condition) {
            throw new AssertionError((Object)message);
        }
    }

    public static void checkByteArrayBounds(byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("Byte array cannot be null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset must be non-negative");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("Length must be non-negative");
        }
        if (offset + length > bytes.length) {
            throw new IndexOutOfBoundsException("Offset + length must not exceed the length of the byte array. Offset: " + offset + ", Length: " + length + ", Byte array size: " + bytes.length);
        }
    }

    public static <T extends Comparable<T>> void valueRange(T value, T minValue, T maxValue) {
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw new AssertionError((Object)("input (" + value + ") out of range [" + minValue + ", " + maxValue + "]"));
        }
    }
}

