/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.io.reader.InputStreamWrapper;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.utils.StringFormatter;
import java.io.File;
import java.io.IOException;

public class DockerCopyer {
    final String docker;
    final String containerID;

    public DockerCopyer(String containerID) throws IOException {
        this("docker", containerID);
    }

    public DockerCopyer(String dockerProgram, String containerID) throws IOException {
        this.docker = dockerProgram;
        this.containerID = containerID;
        Process process = new ProcessBuilder("bash", "-c", this.docker + " inspect --format='{{.State.Running}}' " + this.containerID).directory(RuntimeProperty.WORKSPACE_PATH).start();
        try (ReaderStream out = new ReaderStream(new InputStreamWrapper(process.getInputStream()));){
            if (!out.readAll().toString().equals("true")) {
                throw new IOException("No such active container: " + containerID);
            }
        }
    }

    public File get(String dockerPath, String localPath) throws IOException {
        String command = new StringFormatter("{docker} cp {containerID}:{dockerPath} {localPath} -q").format("docker", this.docker).format("containerID", this.containerID).format("dockerPath", dockerPath).format("localPath", localPath).toString();
        Process process = new ProcessBuilder("bash", "-c", command).directory(RuntimeProperty.WORKSPACE_PATH).start();
        int returnCode = 0;
        try {
            returnCode = process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            returnCode = -1;
        }
        if (returnCode != 0) {
            throw new RuntimeException("An exception occurred when executing the Shell command. The command information is as follows: \n" + command);
        }
        return new File(localPath);
    }

    public void send(String localPath, String dockerPath) throws IOException {
        String command = new StringFormatter("{docker} cp {localPath} {containerID}:{dockerPath} -q").format("docker", this.docker).format("containerID", this.containerID).format("dockerPath", dockerPath).format("localPath", localPath).toString();
        Process process = new ProcessBuilder("bash", "-c", command).directory(RuntimeProperty.WORKSPACE_PATH).start();
        int returnCode = 0;
        try {
            returnCode = process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            returnCode = -1;
        }
        if (returnCode != 0) {
            throw new RuntimeException("An exception occurred when executing the Shell command. The command information is as follows: \n" + command);
        }
    }

    public String getContainerID() {
        return this.containerID;
    }
}

