/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.executor.ThreadQueue;
import edu.sysu.pmglab.io.FileUtils;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.file.LocalFile;
import edu.sysu.pmglab.io.partreader.BoundReader;
import edu.sysu.pmglab.io.reader.IReaderStream;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.reader.ReaderStream;
import edu.sysu.pmglab.io.writer.WriterStream;
import edu.sysu.pmglab.progressbar.ProgressBar;
import edu.sysu.pmglab.progressbar.ProgressConsumer;
import edu.sysu.pmglab.progressbar.ProgressRenderer;
import edu.sysu.pmglab.progressbar.TextProgressRenderer;
import edu.sysu.pmglab.progressbar.console.ConsoleConsumer;
import edu.sysu.pmglab.progressbar.unit.DataLengthUnit;
import edu.sysu.pmglab.utils.ValueUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;

public class Downloader {
    final LiveFile remoteFile;
    final File output;
    final ProgressBar.Builder bar = new ProgressBar.Builder().setRenderer(new TextProgressRenderer("Downloaded", DataLengthUnit.B)).setConsumer(new ConsoleConsumer());
    int nThreads = 1;
    boolean resume = true;

    public Downloader(LiveFile remoteFile, File output) {
        this.remoteFile = remoteFile;
        this.output = output == null ? new File(RuntimeProperty.WORKSPACE_PATH, remoteFile.getName()) : output;
        this.bar.setInitialMax(remoteFile.length());
    }

    public Downloader setProgressType(ProgressConsumer consumer, ProgressRenderer renderer) {
        this.bar.setConsumer(consumer);
        this.bar.setRenderer(renderer);
        return this;
    }

    public Downloader silent(boolean silent) {
        if (silent) {
            this.bar.setRenderer(ProgressRenderer.SILENT);
            this.bar.setConsumer(ProgressConsumer.SILENT);
        } else {
            this.bar.setRenderer(new TextProgressRenderer("Downloaded", DataLengthUnit.B));
            this.bar.setConsumer(new ConsoleConsumer());
        }
        return this;
    }

    public Downloader resume(boolean resume) {
        this.resume = resume;
        return this;
    }

    public Downloader setThreads(int nThreads) {
        this.nThreads = ValueUtils.valueOf(nThreads, 1, 16);
        return this;
    }

    public int compareTime() {
        if (this.output.exists()) {
            return Long.compare(this.output.lastModified(), this.remoteFile.lastModifyTime());
        }
        return -1;
    }

    public LocalFile download() throws IOException {
        if (this.resume && this.output.exists() && this.output.length() == this.remoteFile.length() && this.compareTime() == 0) {
            ProgressBar bar = this.bar.startsFrom(this.output.length()).build();
            bar.close();
            return new LocalFile(this.output);
        }
        File tempDir = new File(this.output.getPath() + ".$temp");
        if (!this.resume) {
            FileUtils.delete(tempDir);
            if (tempDir.exists()) {
                throw new FileSystemException("Readonly file system: " + tempDir);
            }
        }
        FileUtils.deleteFile(this.output);
        if (this.output.exists()) {
            throw new FileSystemException("Readonly file system: " + this.output);
        }
        tempDir.mkdirs();
        if (!tempDir.exists()) {
            throw new FileSystemException("Readonly file system: " + tempDir);
        }
        ProgressBar bar = this.bar.build();
        ThreadQueue queue = new ThreadQueue(this.nThreads);
        List<LongInterval> tasks = new LongInterval(0L, this.remoteFile.length()).divide(this.nThreads, false);
        int i = 0;
        while (i < tasks.size()) {
            int partIndex = i++;
            queue.addTask((status, context) -> {
                LongInterval task = (LongInterval)tasks.get(partIndex);
                File partTemp = FileUtils.getSubFile(tempDir, String.valueOf(partIndex));
                if (partTemp.length() == task.end() - task.start()) {
                    bar.step(partTemp.length());
                    return;
                }
                if (partTemp.length() > task.end() - task.start()) {
                    FileUtils.delete(partTemp);
                }
                WriterStream writer = new WriterStream(partTemp, WriterStream.Option.APPEND);
                BoundReader reader = new BoundReader(this.remoteFile.openAsBinary(), task);
                ((ISeekableReaderStream)reader).seek(partTemp.length());
                bar.step(partTemp.length());
                ByteStream cache = new ByteStream(8192, false);
                while (reader.read(cache, cache.capacity()) != -1) {
                    writer.write(cache.bytes(), cache.start(), cache.length());
                    bar.step(cache.length());
                    cache.clear();
                }
                ((IReaderStream)reader).close();
                writer.close();
            });
        }
        queue.close();
        bar.close();
        WriterStream writer = new WriterStream(this.output, WriterStream.Option.DEFAULT);
        for (int i2 = 0; i2 < tasks.size(); ++i2) {
            File tempFile = FileUtils.getSubFile(tempDir, String.valueOf(i2));
            ReaderStream reader = new ReaderStream(tempFile.getPath(), ReaderStream.Option.DEFAULT);
            reader.transferTo(0L, reader.length(), writer);
            reader.close();
            tempFile.delete();
        }
        writer.close();
        FileUtils.delete(tempDir);
        this.output.setLastModified(this.remoteFile.lastModifyTime());
        return new LocalFile(this.output);
    }
}

