/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import edu.sysu.pmglab.bytecode.ByteStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Formatter;

public enum MD5 {
    INSTANCE;

    final MessageDigest md5;

    private MD5() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new UnsupportedOperationException("Invalid Exception");
        }
    }

    public static String check(byte[] src) {
        return MD5.check(src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String check(byte[] src, int offset, int length) {
        MD5 mD5 = INSTANCE;
        synchronized (mD5) {
            MD5.INSTANCE.md5.reset();
            MD5.INSTANCE.md5.update(src, offset, length);
            return MD5.toString(MD5.INSTANCE.md5.digest());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String check(InputStream src) throws IOException {
        MD5 mD5 = INSTANCE;
        synchronized (mD5) {
            int length;
            MD5.INSTANCE.md5.reset();
            ByteStream cache = ByteStream.getThreadInstance();
            while ((length = src.read(cache.bytes(), 0, cache.capacity())) != -1) {
                MD5.INSTANCE.md5.update(cache.bytes(), 0, length);
            }
            return MD5.toString(MD5.INSTANCE.md5.digest());
        }
    }

    public static String toString(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("Invalid md5 checksum: " + Arrays.toString(bytes));
        }
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }
}

