/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class MapUtils {
    private MapUtils() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static <K1, K2, V> Map<K2, V> keyMapper(Map<K1, V> map, Function<K1, K2> mapper) {
        LinkedHashMap<K2, V> returns = new LinkedHashMap<K2, V>();
        for (K1 key : map.keySet()) {
            returns.put(mapper.apply(key), map.get(key));
        }
        return returns;
    }

    public static <K, V1, V2> Map<K, V2> valueMapper(Map<K, V1> map, Function<V1, V2> mapper) {
        LinkedHashMap<K, V2> returns = new LinkedHashMap<K, V2>();
        for (K key : map.keySet()) {
            returns.put(key, mapper.apply(map.get(key)));
        }
        return returns;
    }

    public static <K1, K2, V1, V2> Map<K2, V2> mapMapper(Map<K1, V1> map, Function<K1, K2> keyMapper, Function<V1, V2> valueMapper) {
        LinkedHashMap<K2, V2> returns = new LinkedHashMap<K2, V2>();
        for (K1 key : map.keySet()) {
            returns.put(keyMapper.apply(key), valueMapper.apply(map.get(key)));
        }
        return returns;
    }

    public static <K, V> Map<V, K> flip(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<V, K> returns = new LinkedHashMap<V, K>();
        for (K key : map.keySet()) {
            returns.put(map.get(key), key);
        }
        return returns;
    }

    public static <V1, V2> Set<V2> setMapper(Set<V1> set, Function<V1, V2> valueMapper) {
        LinkedHashSet<V2> returns = new LinkedHashSet<V2>();
        for (V1 value : set) {
            returns.add(valueMapper.apply(value));
        }
        return returns;
    }

    public static <T> LinkedHashSet<T> toLinkedHashSet(Iterable<T> values2) {
        LinkedHashSet<T> returns = new LinkedHashSet<T>();
        if (values2 != null) {
            for (T value : values2) {
                returns.add(value);
            }
        }
        return returns;
    }

    public static <K> Map<K, ?> of(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.EMPTY_MAP;
        }
        if (objects.length % 2 == 1) {
            throw new UnsupportedOperationException();
        }
        LinkedHashMap<Object, Object> maps = new LinkedHashMap<Object, Object>();
        int l = objects.length / 2;
        for (int i = 0; i < l; ++i) {
            maps.put(objects[i << 1], objects[(i << 1) + 1]);
        }
        return maps;
    }
}

