/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.EmptyArray;
import edu.sysu.pmglab.container.list.List;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ReflectionUtils {
    private ReflectionUtils() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static <T> T getInstance(Class<? extends T> tClass, Class[] inputTypes, Object[] params) {
        if (inputTypes == null) {
            inputTypes = EmptyArray.CLASS;
        }
        if (params == null) {
            params = EmptyArray.OBJECT;
        }
        if (inputTypes.length != params.length) {
            throw new IllegalArgumentException("Wrong number of arguments");
        }
        try {
            if (tClass.isEnum()) {
                if (inputTypes.length == 0) {
                    if (tClass.getEnumConstants().length == 1) {
                        return tClass.getEnumConstants()[0];
                    }
                    throw new NoSuchMethodException(tClass + " contains has 0 or over 1 enum constant (single instance required)");
                }
                throw new NoSuchMethodException(tClass.getName() + ".<init>(" + List.wrap(inputTypes).apply(Class::getName).toString(", ") + ")");
            }
            if (inputTypes.length == 0) {
                Constructor<T> constructor = tClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            Constructor<T> constructor = tClass.getDeclaredConstructor(inputTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (Error | Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getCallerClass() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (stackTraceElements.length >= 4) {
            try {
                return Class.forName(stackTraceElements[3].getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static List<Field> getFields(Class<?> tClass) {
        List<Field> fields = new List<Field>();
        while (tClass != null && tClass != Object.class) {
            fields.addAll((Field[])tClass.getDeclaredFields());
            tClass = tClass.getSuperclass();
        }
        return fields;
    }

    public static List<Field> getFields(Class<?> tClass, IFilter<Field> filter) {
        if (filter == null) {
            return ReflectionUtils.getFields(tClass);
        }
        List<Field> fields = new List<Field>();
        while (tClass != null && tClass != Object.class) {
            for (Field field : tClass.getDeclaredFields()) {
                if (!filter.filter(field)) continue;
                fields.add(field);
            }
            tClass = tClass.getSuperclass();
        }
        return fields;
    }

    public static Field getField(Class<?> tClass, String name) {
        try {
            return tClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<T> annotation, Object object) {
        if (object instanceof Class) {
            return ((Class)object).getAnnotation(annotation);
        }
        return object.getClass().getAnnotation(annotation);
    }

    public static void setValue(Object instance, Field field, Object value) {
        try {
            if (Modifier.isFinal(field.getModifiers())) {
                Object originValue = ReflectionUtils.getValue(instance, field);
                if (originValue == null && value == null) {
                    return;
                }
                if (originValue != null && value != null && originValue.getClass() == value.getClass() && (originValue.getClass() == String.class || originValue.getClass() == Byte.class || originValue.getClass() == Short.class || originValue.getClass() == Integer.class || originValue.getClass() == Long.class || originValue.getClass() == Float.class || originValue.getClass() == Double.class) && originValue.equals(value)) {
                    return;
                }
                throw new IllegalAccessException("Modification of final field is not allowed through reflection");
            }
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                field.set(null, value);
            } else {
                field.set(instance, value);
            }
            if (!accessible) {
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getValue(Object instance, Field field) {
        try {
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            try {
                if (Modifier.isStatic(field.getModifiers())) {
                    Object object = field.get(null);
                    return (T)object;
                }
                Object object = field.get(instance);
                return (T)object;
            }
            finally {
                if (!accessible) {
                    field.setAccessible(false);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

