/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ShellUtils {
    private ShellUtils() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static int execute(String command) throws Exception {
        return ShellUtils.execute(command, 0L, TimeUnit.SECONDS);
    }

    public static int execute(String command, long timeout2, TimeUnit timeUnit) throws Exception {
        Process process = null;
        try {
            int exitCode;
            String[] shellCommand = System.getProperty("os.name").toLowerCase().startsWith("win") ? new String[]{"cmd.exe", "/c", command} : new String[]{"sh", "-c", command};
            ProcessBuilder pb = new ProcessBuilder(shellCommand);
            pb.redirectErrorStream(true);
            process = pb.start();
            StreamConsumer outputConsumer = new StreamConsumer(process.getInputStream(), System.out, "[SHELL-OUTPUT] ");
            outputConsumer.start();
            if (timeout2 > 0L) {
                if (!process.waitFor(timeout2, timeUnit)) {
                    throw new TimeoutException("Command timed out after " + timeout2 + " " + (Object)((Object)timeUnit));
                }
            } else {
                process.waitFor();
            }
            if ((exitCode = process.exitValue()) != 0) {
                throw new ExecutionException("Command exited with code " + exitCode, exitCode);
            }
            int n = exitCode;
            return n;
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to execute command: " + e.getMessage(), -1, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExecutionException("Command execution interrupted", -1, e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    public static class ExecutionException
    extends Exception {
        private final int exitCode;

        public ExecutionException(String message, int exitCode) {
            super(message);
            this.exitCode = exitCode;
        }

        public ExecutionException(String message, int exitCode, Throwable cause) {
            super(message, cause);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    private static class StreamConsumer
    extends Thread {
        private final InputStream inputStream;
        private final Appendable output;
        private final String prefix;

        StreamConsumer(InputStream inputStream2, Appendable output, String prefix) {
            this.inputStream = inputStream2;
            this.output = output;
            this.prefix = prefix;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Appendable appendable = this.output;
                    synchronized (appendable) {
                        this.output.append(this.prefix).append(line).append("\n");
                    }
                }
                return;
            }
            catch (IOException e) {
                System.err.println("Error reading stream: " + e.getMessage());
            }
        }
    }
}

