/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import edu.sysu.pmglab.container.list.List;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFormatter {
    private static final String PLACEHOLDER_PREFIX = "{";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{.*?}");
    private final String string;
    private final List<String> variableNames;
    private final Map<String, String> params;

    public StringFormatter(String ... strings) {
        if (strings == null) {
            throw new NullPointerException();
        }
        if (strings.length == 0) {
            this.string = "";
            this.variableNames = null;
            this.params = new LinkedHashMap<String, String>(0);
            return;
        }
        StringBuilder linker = new StringBuilder();
        for (String param : strings) {
            if (param == null) continue;
            linker.append(param);
        }
        if (linker.length() <= 1) {
            this.string = "";
            this.variableNames = null;
            this.params = new LinkedHashMap<String, String>(0);
            return;
        }
        List<String> placeholders = new List<String>(4);
        this.variableNames = new List(4);
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(linker);
        while (matcher.find()) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                String s = matcher.group(i);
                placeholders.add(s);
                this.variableNames.add(s.substring(PLACEHOLDER_PREFIX.length(), s.length() - PLACEHOLDER_SUFFIX.length()).trim());
            }
        }
        StringBuilder string = new StringBuilder(linker.length());
        int index = 0;
        for (String placeholder : placeholders) {
            int placeHolderStartIndex = linker.indexOf(placeholder, index);
            if (index < placeHolderStartIndex) {
                string.append(linker, index, placeHolderStartIndex);
            }
            string.append("%s");
            index = placeHolderStartIndex + placeholder.length();
        }
        if (index < linker.length()) {
            string.append(linker, index, linker.length());
        }
        this.string = string.toString();
        this.params = new LinkedHashMap<String, String>(this.variableNames.size());
    }

    public static StringFormatter join(String joiner, String ... strings) {
        if (strings == null || strings.length == 0) {
            return new StringFormatter(new String[0]);
        }
        StringBuilder linker = new StringBuilder();
        for (String param : strings) {
            if (param == null) continue;
            if (linker.length() != 0) {
                linker.append(joiner);
            }
            linker.append(param);
        }
        return new StringFormatter(linker.toString());
    }

    public StringFormatter format(Map<Object, ?> params) {
        if (params != null) {
            for (String key : this.variableNames) {
                if (!params.containsKey(key)) continue;
                this.params.put(key, params.get(key).toString());
            }
        }
        return this;
    }

    public StringFormatter format(String key, Object value) {
        this.params.put(key, value.toString());
        return this;
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public boolean containsVariable(String name) {
        return this.variableNames.contains(name);
    }

    public String toString() {
        if (this.string.length() == 0) {
            return "";
        }
        Object[] objects = this.variableNames.apply(s -> {
            String value = this.params.get(s);
            if (value == null) {
                return "null";
            }
            return this.params.get(s);
        }).toArray();
        return String.format(this.string, objects);
    }
}

