/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.utils;

import edu.sysu.pmglab.container.list.List;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ValueUtils {
    private ValueUtils() {
    }

    public static <T extends Comparable<T>> T min(T a, T b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static <T extends Comparable<T>> T max(T a, T b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    public static int sum(int ... values2) {
        int totalValue = 0;
        for (int value : values2) {
            totalValue = Math.addExact(totalValue, value);
        }
        return totalValue;
    }

    public static long sum(long ... values2) {
        long totalValue = 0L;
        for (long value : values2) {
            totalValue = Math.addExact(totalValue, value);
        }
        return totalValue;
    }

    public static float sum(float ... values2) {
        float totalValue = 0.0f;
        for (float value : values2) {
            totalValue += value;
        }
        return totalValue;
    }

    public static double sum(double ... values2) {
        double totalValue = 0.0;
        for (double value : values2) {
            totalValue += value;
        }
        return totalValue;
    }

    public static double round(double value, int decimal) {
        return new BigDecimal(value).setScale(decimal, RoundingMode.FLOOR).doubleValue();
    }

    public static float round(float value, int decimal) {
        return new BigDecimal(value).setScale(decimal, RoundingMode.FLOOR).floatValue();
    }

    public static <T extends Comparable<T>> boolean intersect(T lowerBoundA, T upBoundA, T lowerBoundB, T upBoundB) {
        return ValueUtils.max(lowerBoundA, lowerBoundB).compareTo(ValueUtils.min(upBoundA, upBoundB)) <= 0;
    }

    public static <T extends Comparable<T>> T valueOf(T value, T lowerBound, T upperBound) {
        return ValueUtils.max(lowerBound, ValueUtils.min(value, upperBound));
    }

    public static int valueOf(int value, int lowerBound, int upperBound) {
        if (lowerBound > upperBound) {
            return lowerBound;
        }
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static long valueOf(long value, long lowerBound, long upperBound) {
        if (lowerBound > upperBound) {
            return lowerBound;
        }
        return Math.max(lowerBound, Math.min(value, upperBound));
    }

    public static <T> T getOrDefault(T value, T replace) {
        if (value == null) {
            return replace;
        }
        return value;
    }

    public static String changeEnds(String input, String end, String ... matchers) {
        end = end == null || end.length() == 0 ? "" : end;
        List<String> matcherArray = new List<String>(matchers);
        matcherArray.sort((string1, string2) -> -Integer.compare(string1.length(), string2.length()));
        for (String match : matcherArray) {
            if (!input.endsWith(match)) continue;
            input = input.substring(0, input.length() - match.length()) + end;
            return input;
        }
        if (input.endsWith(end)) {
            return input;
        }
        return input + end;
    }

    public static int count(String string, char c) {
        int count = 0;
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (string.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }
}

