/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFile;
import io.jhdf.api.Attribute;
import io.jhdf.api.Group;
import io.jhdf.api.WritableAttributeImpl;
import io.jhdf.api.WritableNode;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractWritableNode
implements WritableNode {
    private final Group parent;
    private final String name;
    private final Map<String, Attribute> attributes = new HashMap<String, Attribute>();

    AbstractWritableNode(Group parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        if (this.parent == null) {
            return "/" + this.getName();
        }
        return this.parent.getPath() + "/" + this.getName();
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public File getFile() {
        return this.parent.getFile();
    }

    @Override
    public Path getFileAsPath() {
        return this.parent.getFileAsPath();
    }

    @Override
    public HdfFile getHdfFile() {
        return this.parent.getHdfFile();
    }

    @Override
    public Attribute putAttribute(String name, Object data) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        Objects.requireNonNull(data, "Cannot write null attributes");
        WritableAttributeImpl attribute = new WritableAttributeImpl(name, this, data);
        return this.attributes.put(name, attribute);
    }

    @Override
    public Attribute removeAttribute(String name) {
        return this.attributes.remove(name);
    }
}

