/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.checksum.ChecksumUtils;
import io.jhdf.exceptions.HdfException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;

public class BufferBuilder {
    public static final long UNSIGNED_BYTE_MAX = 254L;
    public static final long UNSIGNED_SHORT_MAX = 65534L;
    private static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);

    public BufferBuilder writeByte(int i) {
        try {
            this.dataOutputStream.writeByte(i);
            return this;
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
    }

    public BufferBuilder writeBytes(byte[] bytes) {
        try {
            this.dataOutputStream.write(bytes);
            return this;
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
    }

    public BufferBuilder writeShort(int i) {
        try {
            short s = (short)i;
            if (BYTE_ORDER == ByteOrder.LITTLE_ENDIAN) {
                s = Short.reverseBytes(s);
            }
            this.dataOutputStream.writeShort(s);
            return this;
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
    }

    public BufferBuilder writeInt(int i) {
        try {
            if (BYTE_ORDER == ByteOrder.LITTLE_ENDIAN) {
                i = Integer.reverseBytes(i);
            }
            this.dataOutputStream.writeInt(i);
            return this;
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
    }

    public BufferBuilder writeLong(long l) {
        try {
            if (BYTE_ORDER == ByteOrder.LITTLE_ENDIAN) {
                l = Long.reverseBytes(l);
            }
            this.dataOutputStream.writeLong(l);
            return this;
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
    }

    public ByteBuffer build() {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArrayOutputStream.toByteArray());
            byteBuffer.order(BYTE_ORDER);
            this.dataOutputStream.close();
            this.byteArrayOutputStream.close();
            return byteBuffer;
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
    }

    public BufferBuilder writeBitSet(BitSet bitSet, int lengthBytes) {
        if (bitSet.toByteArray().length > lengthBytes) {
            throw new IllegalArgumentException("BitSet is longer than length provided");
        }
        try {
            byte[] bytes = Arrays.copyOf(bitSet.toByteArray(), lengthBytes);
            this.dataOutputStream.write(bytes);
            return this;
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
    }

    public BufferBuilder appendChecksum() {
        this.writeInt(ChecksumUtils.checksum(this.byteArrayOutputStream.toByteArray()));
        return this;
    }

    public BufferBuilder writeBuffer(ByteBuffer byteBuffer) {
        try {
            this.dataOutputStream.write(byteBuffer.array());
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
        return this;
    }

    public BufferBuilder writeShortestRepresentation(int i) {
        try {
            if ((long)i <= 254L) {
                this.dataOutputStream.writeByte(i);
            } else if ((long)i <= 65534L) {
                this.dataOutputStream.writeShort(i);
            } else {
                this.dataOutputStream.write(i);
            }
        }
        catch (IOException e) {
            throw new BufferBuilderException(e);
        }
        return this;
    }

    public String toString() {
        return "BufferBuilder{bytesWriten=" + this.dataOutputStream.size() + "}";
    }

    public static final class BufferBuilderException
    extends HdfException {
        private BufferBuilderException(String message, Throwable throwable) {
            super(message, throwable);
        }

        private BufferBuilderException(Throwable throwable) {
            this("Error in BufferBuilder", throwable);
        }
    }
}

