/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.AbstractWritableNode;
import io.jhdf.HdfFile;
import io.jhdf.ObjectHeader;
import io.jhdf.Utils;
import io.jhdf.api.Attribute;
import io.jhdf.api.Group;
import io.jhdf.api.NodeType;
import io.jhdf.api.WritiableDataset;
import io.jhdf.exceptions.HdfWritingException;
import io.jhdf.filter.PipelineFilterWithData;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.message.AttributeInfoMessage;
import io.jhdf.object.message.AttributeMessage;
import io.jhdf.object.message.DataLayout;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.object.message.DataSpace;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.FillValueMessage;
import io.jhdf.object.message.Message;
import io.jhdf.storage.HdfFileChannel;
import java.io.File;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableDatasetImpl
extends AbstractWritableNode
implements WritiableDataset {
    private static final Logger logger = LoggerFactory.getLogger(WritableDatasetImpl.class);
    private final Object data;
    private final DataType dataType;
    private final DataSpace dataSpace;

    public WritableDatasetImpl(Object data, String name, Group parent) {
        super(parent, name);
        this.data = data;
        this.dataType = DataType.fromObject(data);
        this.dataSpace = DataSpace.fromObject(data);
    }

    @Override
    public long getSize() {
        return this.dataSpace.getTotalLength();
    }

    @Override
    public long getSizeInBytes() {
        return this.getSize() * (long)this.dataType.getSize();
    }

    @Override
    public long getStorageInBytes() {
        return this.getSizeInBytes();
    }

    @Override
    public int[] getDimensions() {
        return this.dataSpace.getDimensions();
    }

    @Override
    public boolean isScalar() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getDimensions().length == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public boolean isCompound() {
        return false;
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    @Override
    public long[] getMaxSize() {
        return this.dataSpace.getMaxSizes();
    }

    @Override
    public DataLayout getDataLayout() {
        return DataLayout.CONTIGUOUS;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Object getDataFlat() {
        return Utils.flatten(this.data);
    }

    @Override
    public Object getData(long[] sliceOffset, int[] sliceDimensions) {
        throw new HdfWritingException("Slicing a writable dataset not supported");
    }

    @Override
    public Class<?> getJavaType() {
        Class<?> type = this.dataType.getJavaType();
        if (this.isScalar() && type.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(type);
        }
        return type;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public Object getFillValue() {
        return null;
    }

    @Override
    public List<PipelineFilterWithData> getFilters() {
        return Collections.emptyList();
    }

    @Override
    public NodeType getType() {
        return NodeType.DATASET;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public Path getFileAsPath() {
        return this.getParent().getFileAsPath();
    }

    @Override
    public HdfFile getHdfFile() {
        return this.getParent().getHdfFile();
    }

    @Override
    public long getAddress() {
        throw new HdfWritingException("Address not known until written");
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return false;
    }

    @Override
    public long write(HdfFileChannel hdfFileChannel, long position) {
        logger.info("Writing dataset [{}] at position [{}]", (Object)this.getPath(), (Object)position);
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(DataTypeMessage.create(this.dataType));
        messages.add(DataSpaceMessage.create(this.dataSpace));
        messages.add(FillValueMessage.NO_FILL);
        DataLayoutMessage.ContiguousDataLayoutMessage placeholder = DataLayoutMessage.ContiguousDataLayoutMessage.create(-1L, -1L);
        messages.add(placeholder);
        if (!this.getAttributes().isEmpty()) {
            AttributeInfoMessage attributeInfoMessage = AttributeInfoMessage.create();
            messages.add(attributeInfoMessage);
            for (Map.Entry<String, Attribute> attribute : this.getAttributes().entrySet()) {
                logger.info("Writing attribute [{}]", (Object)attribute.getKey());
                AttributeMessage attributeMessage = AttributeMessage.create(attribute.getKey(), attribute.getValue());
                messages.add(attributeMessage);
            }
        }
        ObjectHeader.ObjectHeaderV2 objectHeader = new ObjectHeader.ObjectHeaderV2(position, messages);
        int ohSize = objectHeader.toBuffer().limit();
        long dataAddress = position + (long)ohSize;
        long dataSize = this.writeData(hdfFileChannel, dataAddress);
        messages.add(DataLayoutMessage.ContiguousDataLayoutMessage.create(dataAddress, dataSize));
        messages.remove(placeholder);
        objectHeader = new ObjectHeader.ObjectHeaderV2(position, messages);
        hdfFileChannel.write(objectHeader.toBuffer(), position);
        return dataAddress + dataSize;
    }

    private long writeData(HdfFileChannel hdfFileChannel, long dataAddress) {
        logger.info("Writing data for dataset [{}] at position [{}]", (Object)this.getPath(), (Object)dataAddress);
        hdfFileChannel.position(dataAddress);
        this.dataType.writeData(this.data, this.getDimensions(), hdfFileChannel);
        return this.dataSpace.getTotalLength() * (long)this.dataType.getSize();
    }

    private static void writeDoubleData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                WritableDatasetImpl.writeDoubleData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel);
            }
        } else {
            buffer.asDoubleBuffer().put((double[])data);
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }
}

