/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFile;
import io.jhdf.JhdfInfo;
import io.jhdf.Superblock;
import io.jhdf.WritableGroupImpl;
import io.jhdf.api.Attribute;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.api.WritableGroup;
import io.jhdf.api.WritiableDataset;
import io.jhdf.exceptions.HdfWritingException;
import io.jhdf.storage.HdfFileChannel;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableHdfFile
implements WritableGroup,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(WritableHdfFile.class);
    public static final long ROOT_GROUP_ADDRESS = 64L;
    private final Path path;
    private final FileChannel fileChannel;
    private final Superblock.SuperblockV2V3 superblock;
    private final HdfFileChannel hdfFileChannel;
    private final WritableGroup rootGroup;

    WritableHdfFile(Path path) {
        logger.warn("Writing files is in alpha. Check files carefully!");
        logger.info("Writing HDF5 file to [{}]", (Object)path.toAbsolutePath());
        this.path = path;
        try {
            this.fileChannel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new HdfWritingException("Failed to open file: " + path.toAbsolutePath(), e);
        }
        this.superblock = new Superblock.SuperblockV2V3();
        this.hdfFileChannel = new HdfFileChannel(this.fileChannel, this.superblock);
        this.rootGroup = new WritableGroupImpl(null, "/");
        this.rootGroup.putAttribute("_jHDF", WritableHdfFile.getJHdfInfo());
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new HdfWritingException("Failed to close file", e);
        }
    }

    private void flush() {
        logger.info("Flushing to disk [{}]...", (Object)this.path.toAbsolutePath());
        try {
            this.rootGroup.write(this.hdfFileChannel, 64L);
            this.hdfFileChannel.write(this.getJHdfInfoBuffer());
            long endOfFile = this.hdfFileChannel.getFileChannel().size();
            this.hdfFileChannel.write(this.superblock.toBuffer(endOfFile), 0L);
            logger.info("Flushed to disk [{}] file is [{}] bytes", (Object)this.path.toAbsolutePath(), (Object)endOfFile);
        }
        catch (IOException e) {
            throw new HdfWritingException("Error getting file size", e);
        }
    }

    private ByteBuffer getJHdfInfoBuffer() {
        String info = WritableHdfFile.getJHdfInfo();
        return ByteBuffer.wrap(info.getBytes(StandardCharsets.UTF_8));
    }

    private static String getJHdfInfo() {
        return "jHDF - " + JhdfInfo.VERSION + " - " + JhdfInfo.OS + " - " + JhdfInfo.ARCH + " - " + JhdfInfo.BYTE_ORDER;
    }

    @Override
    public WritiableDataset putDataset(String name, Object data) {
        return this.rootGroup.putDataset(name, data);
    }

    @Override
    public WritableGroup putGroup(String name) {
        return this.rootGroup.putGroup(name);
    }

    @Override
    public Map<String, Node> getChildren() {
        return this.rootGroup.getChildren();
    }

    @Override
    public Node getChild(String name) {
        return this.rootGroup.getChild(name);
    }

    @Override
    public Node getByPath(String path) {
        return this.rootGroup.getByPath(path);
    }

    @Override
    public Dataset getDatasetByPath(String path) {
        return this.rootGroup.getDatasetByPath(path);
    }

    @Override
    public boolean isLinkCreationOrderTracked() {
        return this.rootGroup.isLinkCreationOrderTracked();
    }

    @Override
    public Group getParent() {
        return this.rootGroup.getParent();
    }

    @Override
    public String getName() {
        return this.rootGroup.getName();
    }

    @Override
    public String getPath() {
        return this.rootGroup.getPath();
    }

    @Override
    public Map<String, Attribute> getAttributes() {
        return this.rootGroup.getAttributes();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.rootGroup.getAttribute(name);
    }

    @Override
    public Attribute putAttribute(String name, Object data) {
        return this.rootGroup.putAttribute(name, data);
    }

    @Override
    public Attribute removeAttribute(String name) {
        return this.rootGroup.removeAttribute(name);
    }

    @Override
    public NodeType getType() {
        return this.rootGroup.getType();
    }

    @Override
    public boolean isGroup() {
        return this.rootGroup.isGroup();
    }

    @Override
    public File getFile() {
        return this.path.toFile();
    }

    @Override
    public Path getFileAsPath() {
        return this.path;
    }

    @Override
    public HdfFile getHdfFile() {
        return this.rootGroup.getHdfFile();
    }

    @Override
    public long getAddress() {
        return this.rootGroup.getAddress();
    }

    @Override
    public boolean isLink() {
        return this.rootGroup.isLink();
    }

    @Override
    public boolean isAttributeCreationOrderTracked() {
        return this.rootGroup.isAttributeCreationOrderTracked();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.rootGroup.iterator();
    }

    @Override
    public void forEach(Consumer<? super Node> action) {
        this.rootGroup.forEach(action);
    }

    @Override
    public Spliterator<Node> spliterator() {
        return this.rootGroup.spliterator();
    }

    @Override
    public long write(HdfFileChannel hdfFileChannel, long position) {
        throw new UnsupportedOperationException();
    }
}

