/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.api;

import io.jhdf.api.Attribute;
import io.jhdf.api.Node;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.message.DataSpace;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ClassUtils;

public class WritableAttributeImpl
implements Attribute {
    private final String name;
    private final Node node;
    private final Object data;
    private final DataType dataType;
    private final DataSpace dataSpace;

    public WritableAttributeImpl(String name, Node node, Object data) {
        this.name = name;
        this.node = node;
        this.data = data;
        this.dataType = DataType.fromObject(data);
        this.dataSpace = DataSpace.fromObject(data);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.dataSpace.getTotalLength();
    }

    @Override
    public long getSizeInBytes() {
        return this.getSize() * (long)this.dataType.getSize();
    }

    @Override
    public int[] getDimensions() {
        return this.dataSpace.getDimensions();
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public Class<?> getJavaType() {
        Class<?> type = this.dataType.getJavaType();
        if (this.isScalar() && type.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(type);
        }
        return type;
    }

    @Override
    public boolean isScalar() {
        return this.getDimensions().length == 0;
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.dataType.encodeData(this.data);
    }

    @Override
    public DataSpace getDataSpace() {
        return this.dataSpace;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }
}

