/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree.record;

import io.jhdf.btree.record.AttributeNameForIndexedAttributesRecord;
import io.jhdf.btree.record.FilteredDatasetChunks;
import io.jhdf.btree.record.HugeFractalHeapObjectUnfilteredRecord;
import io.jhdf.btree.record.LinkNameForIndexedGroupRecord;
import io.jhdf.btree.record.NonFilteredDatasetChunks;
import io.jhdf.dataset.chunked.DatasetInfo;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.nio.ByteBuffer;

public abstract class BTreeRecord {
    public static <T extends BTreeRecord> T readRecord(int type, ByteBuffer buffer, DatasetInfo datasetInfo) {
        switch (type) {
            case 0: {
                throw new HdfException("b-tree record type 0. Should only be used for testing");
            }
            case 1: {
                return (T)new HugeFractalHeapObjectUnfilteredRecord(buffer);
            }
            case 2: {
                throw new UnsupportedHdfException("b-tree record type 2. Currently not supported");
            }
            case 3: {
                throw new UnsupportedHdfException("b-tree record type 3. Currently not supported");
            }
            case 4: {
                throw new UnsupportedHdfException("b-tree record type 4. Currently not supported");
            }
            case 5: {
                return (T)new LinkNameForIndexedGroupRecord(buffer);
            }
            case 6: {
                throw new UnsupportedHdfException("b-tree record type 6. Currently not supported");
            }
            case 7: {
                throw new UnsupportedHdfException("b-tree record type 7. Currently not supported");
            }
            case 8: {
                return (T)new AttributeNameForIndexedAttributesRecord(buffer);
            }
            case 9: {
                throw new UnsupportedHdfException("b-tree record type 9. Currently not supported");
            }
            case 10: {
                return (T)new NonFilteredDatasetChunks(buffer, datasetInfo);
            }
            case 11: {
                return (T)new FilteredDatasetChunks(buffer, datasetInfo);
            }
        }
        throw new HdfException("Unknown b-tree record type. Type = " + type);
    }
}

