/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.exceptions;

import io.jhdf.exceptions.HdfException;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;

public class HdfInvalidPathException
extends HdfException {
    private static final long serialVersionUID = 1L;
    private final String path;
    private final transient Path file;

    public HdfInvalidPathException(String path, Path file) {
        super("The path '" + path + "' could not be found in the HDF5 file '" + file.toAbsolutePath() + "'");
        this.path = path;
        this.file = file;
    }

    public String getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file.getFileSystem() == FileSystems.getDefault() ? this.file.toFile() : null;
    }

    public Path getFileAsPath() {
        return this.file;
    }
}

