/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.object.datatype.WritableDataType;
import io.jhdf.storage.HdfBackingStorage;
import io.jhdf.storage.HdfFileChannel;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class FixedPoint
extends DataType
implements OrderedDataType,
WritableDataType {
    public static final int CLASS_ID = 0;
    private static final int ORDER_BIT = 0;
    private static final int LOW_PADDING_BIT = 1;
    private static final int HIGH_PADDING_BIT = 2;
    private static final int SIGNED_BIT = 3;
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final boolean signed;
    private final short bitOffset;
    private final short bitPrecision;

    public FixedPoint(ByteBuffer bb) {
        super(bb);
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.signed = this.classBits.get(3);
        this.bitOffset = bb.getShort();
        this.bitPrecision = bb.getShort();
    }

    public FixedPoint(int bytePrecision) {
        super(0, bytePrecision);
        this.order = ByteOrder.nativeOrder();
        this.bitPrecision = (short)(bytePrecision * 8);
        this.lowPadding = false;
        this.highPadding = false;
        this.signed = true;
        this.bitOffset = 0;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.signed) {
            switch (this.bitPrecision) {
                case 8: {
                    return Byte.TYPE;
                }
                case 16: {
                    return Short.TYPE;
                }
                case 32: {
                    return Integer.TYPE;
                }
                case 64: {
                    return Long.TYPE;
                }
            }
            throw new HdfTypeException("Unsupported signed fixed point data type");
        }
        switch (this.bitPrecision) {
            case 8: 
            case 16: {
                return Integer.TYPE;
            }
            case 32: {
                return Long.TYPE;
            }
            case 64: {
                return BigInteger.class;
            }
        }
        throw new HdfTypeException("Unsupported unsigned fixed point data type");
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        Object data;
        block13: {
            ByteOrder byteOrder;
            block12: {
                data = Array.newInstance(this.getJavaType(), dimensions);
                byteOrder = this.getByteOrder();
                if (!this.isSigned()) break block12;
                switch (this.getSize()) {
                    case 1: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder));
                        break block13;
                    }
                    case 2: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder).asShortBuffer());
                        break block13;
                    }
                    case 4: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder).asIntBuffer());
                        break block13;
                    }
                    case 8: {
                        FixedPoint.fillData(data, dimensions, buffer.order(byteOrder).asLongBuffer());
                        break block13;
                    }
                    default: {
                        throw new HdfTypeException("Unsupported signed integer type size " + this.getSize() + " bytes");
                    }
                }
            }
            switch (this.getSize()) {
                case 1: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder));
                    break;
                }
                case 2: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder).asShortBuffer());
                    break;
                }
                case 4: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder).asIntBuffer());
                    break;
                }
                case 8: {
                    FixedPoint.fillDataUnsigned(data, dimensions, buffer.order(byteOrder).asLongBuffer());
                    break;
                }
                default: {
                    throw new HdfTypeException("Unsupported unsigned integer type size " + this.getSize() + " bytes");
                }
            }
        }
        return data;
    }

    @Override
    public ByteBuffer encodeData(Object data) {
        Objects.requireNonNull(data, "Cannot encode null");
        if (data.getClass().isArray()) {
            return this.encodeArrayData(data);
        }
        return this.encodeScalarData(data);
    }

    private ByteBuffer encodeScalarData(Object data) {
        Class<?> type = Utils.getType(data);
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize()).order(this.order);
        if (type == Byte.class) {
            buffer.put((Byte)data);
        } else if (type == Short.class) {
            buffer.asShortBuffer().put((Short)data);
        } else if (type == Integer.class) {
            buffer.asIntBuffer().put((Integer)data);
        } else if (type == Long.class) {
            buffer.asLongBuffer().put((Long)data);
        } else {
            throw new UnsupportedHdfException("Cant write type: " + type);
        }
        return buffer;
    }

    private ByteBuffer encodeArrayData(Object data) {
        Class<?> type = Utils.getType(data);
        int[] dimensions = Utils.getDimensions(data);
        int totalElements = Arrays.stream(dimensions).reduce(1, Math::multiplyExact);
        ByteBuffer buffer = ByteBuffer.allocate(totalElements * this.getSize()).order(this.order);
        if (type == Byte.TYPE) {
            FixedPoint.encodeByteData(data, dimensions, buffer, true);
        } else if (type == Byte.class) {
            FixedPoint.encodeByteData(data, dimensions, buffer, false);
        } else if (type == Short.TYPE) {
            FixedPoint.encodeShortData(data, dimensions, buffer.asShortBuffer(), true);
        } else if (type == Short.class) {
            FixedPoint.encodeShortData(data, dimensions, buffer.asShortBuffer(), false);
        } else if (type == Integer.TYPE) {
            FixedPoint.encodeIntData(data, dimensions, buffer.asIntBuffer(), true);
        } else if (type == Integer.class) {
            FixedPoint.encodeIntData(data, dimensions, buffer.asIntBuffer(), false);
        } else if (type == Long.TYPE) {
            FixedPoint.encodeLongData(data, dimensions, buffer.asLongBuffer(), true);
        } else if (type == Long.class) {
            FixedPoint.encodeLongData(data, dimensions, buffer.asLongBuffer(), false);
        } else {
            throw new UnsupportedHdfException("Cant write type: " + type);
        }
        return buffer;
    }

    private static void fillData(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((byte[])data);
        }
    }

    private static void fillData(Object data, int[] dims, ShortBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((short[])data);
        }
    }

    private static void fillData(Object data, int[] dims, IntBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((int[])data);
        }
    }

    private static void fillData(Object data, int[] dims, LongBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((long[])data);
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, ByteBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            byte[] tempBuffer = new byte[dims[0]];
            buffer.get(tempBuffer);
            int[] intData = (int[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                intData[i] = Byte.toUnsignedInt(tempBuffer[i]);
            }
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, ShortBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            short[] tempBuffer = new short[dims[0]];
            buffer.get(tempBuffer);
            int[] intData = (int[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                intData[i] = Short.toUnsignedInt(tempBuffer[i]);
            }
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, IntBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            int[] tempBuffer = new int[dims[0]];
            buffer.get(tempBuffer);
            long[] longData = (long[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                longData[i] = Integer.toUnsignedLong(tempBuffer[i]);
            }
        }
    }

    private static void fillDataUnsigned(Object data, int[] dims, LongBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.fillDataUnsigned(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            long[] tempBuffer = new long[dims[0]];
            ByteBuffer tempByteBuffer = ByteBuffer.allocate(8);
            buffer.get(tempBuffer);
            BigInteger[] bigIntData = (BigInteger[])data;
            for (int i = 0; i < tempBuffer.length; ++i) {
                tempByteBuffer.putLong(0, tempBuffer[i]);
                bigIntData[i] = new BigInteger(1, tempByteBuffer.array());
            }
        }
    }

    @Override
    public ByteBuffer toBuffer() {
        this.classBits.set(0, this.order.equals(ByteOrder.BIG_ENDIAN));
        this.classBits.set(1, this.lowPadding);
        this.classBits.set(2, this.highPadding);
        this.classBits.set(3, this.signed);
        return super.toBufferBuilder().writeShort(this.bitOffset).writeShort(this.bitPrecision).build();
    }

    @Override
    public void writeData(Object data, int[] dimensions, HdfFileChannel hdfFileChannel) {
        if (data.getClass().isArray()) {
            this.writeArrayData(data, dimensions, hdfFileChannel);
        } else {
            this.writeScalarData(data, hdfFileChannel);
        }
    }

    private void writeScalarData(Object data, HdfFileChannel hdfFileChannel) {
        ByteBuffer buffer = this.encodeScalarData(data);
        buffer.rewind();
        hdfFileChannel.write(buffer);
    }

    private void writeArrayData(Object data, int[] dimensions, HdfFileChannel hdfFileChannel) {
        Class<?> type = Utils.getType(data);
        int fastDimSize = dimensions[dimensions.length - 1];
        ByteBuffer buffer = ByteBuffer.allocate(fastDimSize * this.getSize()).order(this.order);
        if (type == Byte.TYPE) {
            FixedPoint.writeByteData(data, dimensions, buffer, hdfFileChannel, true);
        } else if (type == Byte.class) {
            FixedPoint.writeByteData(data, dimensions, buffer, hdfFileChannel, false);
        } else if (type == Short.TYPE) {
            FixedPoint.writeShortData(data, dimensions, buffer, hdfFileChannel, true);
        } else if (type == Short.class) {
            FixedPoint.writeShortData(data, dimensions, buffer, hdfFileChannel, false);
        } else if (type == Integer.TYPE) {
            FixedPoint.writeIntData(data, dimensions, buffer, hdfFileChannel, true);
        } else if (type == Integer.class) {
            FixedPoint.writeIntData(data, dimensions, buffer, hdfFileChannel, false);
        } else if (type == Long.TYPE) {
            FixedPoint.writeLongData(data, dimensions, buffer, hdfFileChannel, true);
        } else if (type == Long.class) {
            FixedPoint.writeLongData(data, dimensions, buffer, hdfFileChannel, false);
        } else {
            throw new UnsupportedHdfException("Cant write type: " + type);
        }
    }

    private static void writeByteData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.writeByteData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel, primitive);
            }
        } else {
            if (primitive) {
                buffer.put((byte[])data);
            } else {
                buffer.put(ArrayUtils.toPrimitive((Byte[])((Byte[])data)));
            }
            buffer.rewind();
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }

    private static void writeShortData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.writeShortData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel, primitive);
            }
        } else {
            if (primitive) {
                buffer.asShortBuffer().put((short[])data);
            } else {
                buffer.asShortBuffer().put(ArrayUtils.toPrimitive((Short[])((Short[])data)));
            }
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }

    private static void writeIntData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.writeIntData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel, primitive);
            }
        } else {
            if (primitive) {
                buffer.asIntBuffer().put((int[])data);
            } else {
                buffer.asIntBuffer().put(ArrayUtils.toPrimitive((Integer[])((Integer[])data)));
            }
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }

    private static void writeLongData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.writeLongData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel, primitive);
            }
        } else {
            if (primitive) {
                buffer.asLongBuffer().put((long[])data);
            } else {
                buffer.asLongBuffer().put(ArrayUtils.toPrimitive((Long[])((Long[])data)));
            }
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }

    private static void encodeByteData(Object data, int[] dims, ByteBuffer buffer, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.encodeByteData(newArray, Utils.stripLeadingIndex(dims), buffer, primitive);
            }
        } else if (primitive) {
            buffer.put((byte[])data);
        } else {
            buffer.put(ArrayUtils.toPrimitive((Byte[])((Byte[])data)));
        }
    }

    private static void encodeShortData(Object data, int[] dims, ShortBuffer buffer, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.encodeShortData(newArray, Utils.stripLeadingIndex(dims), buffer, primitive);
            }
        } else if (primitive) {
            buffer.put((short[])data);
        } else {
            buffer.put(ArrayUtils.toPrimitive((Short[])((Short[])data)));
        }
    }

    private static void encodeIntData(Object data, int[] dims, IntBuffer buffer, boolean primative) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.encodeIntData(newArray, Utils.stripLeadingIndex(dims), buffer, primative);
            }
        } else if (primative) {
            buffer.put((int[])data);
        } else {
            buffer.put(ArrayUtils.toPrimitive((Integer[])((Integer[])data)));
        }
    }

    private static void encodeLongData(Object data, int[] dims, LongBuffer buffer, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FixedPoint.encodeLongData(newArray, Utils.stripLeadingIndex(dims), buffer, primitive);
            }
        } else if (primitive) {
            buffer.put((long[])data);
        } else {
            buffer.put(ArrayUtils.toPrimitive((Long[])((Long[])data)));
        }
    }
}

