/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.OrderedDataType;
import io.jhdf.storage.HdfBackingStorage;
import io.jhdf.storage.HdfFileChannel;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;

public class FloatingPoint
extends DataType
implements OrderedDataType {
    public static final int CLASS_ID = 1;
    private static final int ORDER_BIT = 0;
    private static final int LOW_PADDING_BIT = 1;
    private static final int HIGH_PADDING_BIT = 2;
    private static final int INTERNAL_PADDING_BIT = 3;
    private final ByteOrder order;
    private final boolean lowPadding;
    private final boolean highPadding;
    private final boolean internalPadding;
    private final int mantissaNormalization;
    private final int signLocation;
    private final short bitOffset;
    private final short bitPrecision;
    private final byte exponentLocation;
    private final byte exponentSize;
    private final byte mantissaLocation;
    private final byte mantissaSize;
    private final int exponentBias;
    public static final FloatingPoint FLOAT = new FloatingPoint(4, 2, 31, 0, 32, 23, 8, 0, 23, 127);
    public static final FloatingPoint DOUBLE = new FloatingPoint(8, 2, 63, 0, 64, 52, 11, 0, 52, 1023);

    public FloatingPoint(ByteBuffer bb) {
        super(bb);
        if (this.classBits.get(6)) {
            throw new UnsupportedHdfException("VAX endian is not supported");
        }
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.internalPadding = this.classBits.get(3);
        this.mantissaNormalization = Utils.bitsToInt(this.classBits, 4, 2);
        this.signLocation = Utils.bitsToInt(this.classBits, 8, 8);
        this.bitOffset = bb.getShort();
        this.bitPrecision = bb.getShort();
        this.exponentLocation = bb.get();
        this.exponentSize = bb.get();
        this.mantissaLocation = bb.get();
        this.mantissaSize = bb.get();
        this.exponentBias = bb.getInt();
    }

    private FloatingPoint(int size, int mantissaNormalization, int signLocation, short bitOffset, short bitPrecision, byte exponentLocation, byte exponentSize, byte mantissaLocation, byte mantissaSize, int exponentBias) {
        super(1, size);
        this.order = ByteOrder.nativeOrder();
        this.lowPadding = false;
        this.highPadding = false;
        this.internalPadding = false;
        this.mantissaNormalization = mantissaNormalization;
        this.signLocation = signLocation;
        this.bitOffset = bitOffset;
        this.bitPrecision = bitPrecision;
        this.exponentLocation = exponentLocation;
        this.exponentSize = exponentSize;
        this.mantissaLocation = mantissaLocation;
        this.mantissaSize = mantissaSize;
        this.exponentBias = exponentBias;
        this.classBits.set(0, this.order.equals(ByteOrder.BIG_ENDIAN));
        this.classBits.set(1, false);
        this.classBits.set(2, false);
        this.classBits.set(3, false);
        Utils.writeIntToBits(mantissaNormalization, this.classBits, 4, 2);
        Utils.writeIntToBits(signLocation, this.classBits, 8, 8);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public boolean isInternalPadding() {
        return this.internalPadding;
    }

    public int getMantissaNormalization() {
        return this.mantissaNormalization;
    }

    public int getSignLocation() {
        return this.signLocation;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    public byte getExponentLocation() {
        return this.exponentLocation;
    }

    public byte getExponentSize() {
        return this.exponentSize;
    }

    public byte getMantissaLocation() {
        return this.mantissaLocation;
    }

    public byte getMantissaSize() {
        return this.mantissaSize;
    }

    public int getExponentBias() {
        return this.exponentBias;
    }

    @Override
    public Class<?> getJavaType() {
        switch (this.bitPrecision) {
            case 16: 
            case 32: {
                return Float.TYPE;
            }
            case 64: {
                return Double.TYPE;
            }
        }
        throw new HdfTypeException("Unsupported signed fixed point data type");
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        ByteOrder byteOrder = this.getByteOrder();
        switch (this.getSize()) {
            case 2: {
                FloatingPoint.fillData(data, dimensions, buffer.order(byteOrder).asShortBuffer());
                break;
            }
            case 4: {
                FloatingPoint.fillData(data, dimensions, buffer.order(byteOrder).asFloatBuffer());
                break;
            }
            case 8: {
                FloatingPoint.fillData(data, dimensions, buffer.order(byteOrder).asDoubleBuffer());
                break;
            }
            default: {
                throw new HdfTypeException("Unsupported floating point type size " + this.getSize() + " bytes");
            }
        }
        return data;
    }

    private static void fillData(Object data, int[] dims, ShortBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            float[] floatData = (float[])data;
            for (int i = 0; i < dims[0]; ++i) {
                short element = buffer.get();
                floatData[i] = FloatingPoint.toFloat(element);
            }
        }
    }

    public static float toFloat(short element) {
        int mant = element & 0x3FF;
        int exp = element & 0x7C00;
        if (exp == 31744) {
            exp = 261120;
        } else if (exp != 0) {
            exp += 114688;
        } else if (mant != 0) {
            exp = 115712;
            do {
                exp -= 1024;
            } while (((mant <<= 1) & 0x400) == 0);
            mant &= 0x3FF;
        }
        return Float.intBitsToFloat((element & 0x8000) << 16 | (exp | mant) << 13);
    }

    private static void fillData(Object data, int[] dims, FloatBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((float[])data);
        }
    }

    private static void fillData(Object data, int[] dims, DoubleBuffer buffer) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.fillData(newArray, Utils.stripLeadingIndex(dims), buffer);
            }
        } else {
            buffer.get((double[])data);
        }
    }

    @Override
    public ByteBuffer toBuffer() {
        return super.toBufferBuilder().writeShort(this.bitOffset).writeShort(this.bitPrecision).writeByte(this.exponentLocation).writeByte(this.exponentSize).writeByte(this.mantissaLocation).writeByte(this.mantissaSize).writeInt(this.exponentBias).build();
    }

    @Override
    public ByteBuffer encodeData(Object data) {
        Objects.requireNonNull(data, "Cannot encode null");
        Class<?> type = Utils.getType(data);
        if (data.getClass().isArray()) {
            int[] dimensions = Utils.getDimensions(data);
            int totalElements = Arrays.stream(dimensions).reduce(1, Math::multiplyExact);
            ByteBuffer buffer = ByteBuffer.allocate(totalElements * this.getSize()).order(this.order);
            if (type == Float.TYPE) {
                FloatingPoint.encodeFloatData(data, dimensions, buffer.asFloatBuffer(), true);
            } else if (type == Float.class) {
                FloatingPoint.encodeFloatData(data, dimensions, buffer.asFloatBuffer(), false);
            } else if (type == Double.TYPE) {
                FloatingPoint.encodeDoubleData(data, dimensions, buffer.asDoubleBuffer(), true);
            } else if (type == Double.class) {
                FloatingPoint.encodeDoubleData(data, dimensions, buffer.asDoubleBuffer(), false);
            } else {
                throw new UnsupportedHdfException("Cant write type: " + type);
            }
            return buffer;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize()).order(this.order);
        if (type == Float.class) {
            buffer.asFloatBuffer().put(((Float)data).floatValue());
        } else if (type == Double.class) {
            buffer.asDoubleBuffer().put((Double)data);
        } else {
            throw new UnsupportedHdfException("Cant write scalar type: " + type);
        }
        return buffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeData(Object data, int[] dimensions, HdfFileChannel hdfFileChannel) {
        Class<?> type = Utils.getType(data);
        if (data.getClass().isArray()) {
            int fastDimSize = dimensions[dimensions.length - 1];
            ByteBuffer buffer = ByteBuffer.allocate(fastDimSize * this.getSize()).order(this.order);
            if (type == Float.TYPE) {
                FloatingPoint.writeFloatData(data, dimensions, buffer, hdfFileChannel, true);
                return;
            } else if (type == Float.class) {
                FloatingPoint.writeFloatData(data, dimensions, buffer, hdfFileChannel, false);
                return;
            } else if (type == Double.TYPE) {
                FloatingPoint.writeDoubleData(data, dimensions, buffer, hdfFileChannel, true);
                return;
            } else {
                if (type != Double.class) throw new UnsupportedHdfException("Cant write type: " + type);
                FloatingPoint.writeDoubleData(data, dimensions, buffer, hdfFileChannel, false);
            }
            return;
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(this.getSize()).order(this.order);
            if (type == Float.class) {
                buffer.asFloatBuffer().put(((Float)data).floatValue());
            } else {
                if (type != Double.class) throw new UnsupportedHdfException("Cant write scalar type: " + type);
                buffer.asDoubleBuffer().put((Double)data);
            }
            hdfFileChannel.write(buffer);
        }
    }

    private static void writeDoubleData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.writeDoubleData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel, primitive);
            }
        } else {
            if (primitive) {
                buffer.asDoubleBuffer().put((double[])data);
            } else {
                buffer.asDoubleBuffer().put(ArrayUtils.toPrimitive((Double[])((Double[])data)));
            }
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }

    private static void writeFloatData(Object data, int[] dims, ByteBuffer buffer, HdfFileChannel hdfFileChannel, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.writeFloatData(newArray, Utils.stripLeadingIndex(dims), buffer, hdfFileChannel, primitive);
            }
        } else {
            if (primitive) {
                buffer.asFloatBuffer().put((float[])data);
            } else {
                buffer.asFloatBuffer().put(ArrayUtils.toPrimitive((Float[])((Float[])data)));
            }
            hdfFileChannel.write(buffer);
            buffer.clear();
        }
    }

    private static void encodeFloatData(Object data, int[] dims, FloatBuffer buffer, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.encodeFloatData(newArray, Utils.stripLeadingIndex(dims), buffer, primitive);
            }
        } else if (primitive) {
            buffer.put((float[])data);
        } else {
            buffer.put(ArrayUtils.toPrimitive((Float[])((Float[])data)));
        }
    }

    private static void encodeDoubleData(Object data, int[] dims, DoubleBuffer buffer, boolean primitive) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                FloatingPoint.encodeDoubleData(newArray, Utils.stripLeadingIndex(dims), buffer, primitive);
            }
        } else if (primitive) {
            buffer.put((double[])data);
        } else {
            buffer.put(ArrayUtils.toPrimitive((Double[])((Double[])data)));
        }
    }
}

