/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.BufferBuilder;
import io.jhdf.ObjectHeader;
import io.jhdf.Utils;
import io.jhdf.api.Attribute;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.message.DataSpace;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.Message;
import io.jhdf.object.message.SharedMessage;
import io.jhdf.storage.HdfBackingStorage;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMessage
extends Message {
    public static final int MESSAGE_TYPE = 12;
    private static final Logger logger = LoggerFactory.getLogger(AttributeMessage.class);
    private static final int DATA_TYPE_SHARED = 0;
    private static final int DATA_SPACE_SHARED = 1;
    private final byte version;
    private final String name;
    private final DataType dataType;
    private final DataSpace dataSpace;
    private final ByteBuffer data;

    public AttributeMessage(ByteBuffer bb, HdfBackingStorage hdfBackingStorage, BitSet messageFlags) {
        super(messageFlags);
        BitSet flags;
        this.version = bb.get();
        logger.trace("Version: {}", (Object)this.version);
        if (this.version == 1) {
            bb.position(bb.position() + 1);
            flags = BitSet.valueOf(new byte[0]);
        } else {
            flags = BitSet.valueOf(new byte[]{bb.get()});
        }
        int nameSize = Utils.readBytesAsUnsignedInt(bb, 2);
        int dataTypeSize = Utils.readBytesAsUnsignedInt(bb, 2);
        int dataSpaceSize = Utils.readBytesAsUnsignedInt(bb, 2);
        switch (this.version) {
            case 1: {
                this.name = Utils.readUntilNull(Utils.createSubBuffer(bb, nameSize));
                Utils.seekBufferToNextMultipleOfEight(bb);
                break;
            }
            case 2: {
                this.name = Utils.readUntilNull(Utils.createSubBuffer(bb, nameSize));
                break;
            }
            case 3: {
                Charset charset;
                byte characterEncoding = bb.get();
                switch (characterEncoding) {
                    case 0: {
                        charset = StandardCharsets.US_ASCII;
                        break;
                    }
                    case 1: {
                        charset = StandardCharsets.UTF_8;
                        break;
                    }
                    default: {
                        throw new UnsupportedHdfException("Unrecognized character set detected: " + characterEncoding);
                    }
                }
                ByteBuffer nameBuffer = Utils.createSubBuffer(bb, nameSize);
                this.name = charset.decode(nameBuffer).toString().trim();
                break;
            }
            default: {
                throw new UnsupportedHdfException("Unsupported Attribute message version. Detected version: " + this.version);
            }
        }
        switch (this.version) {
            case 1: {
                this.dataType = DataType.readDataType(Utils.createSubBuffer(bb, dataTypeSize));
                Utils.seekBufferToNextMultipleOfEight(bb);
                this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(bb, dataSpaceSize), hdfBackingStorage.getSuperblock());
                Utils.seekBufferToNextMultipleOfEight(bb);
                break;
            }
            case 2: 
            case 3: {
                if (flags.get(0)) {
                    ByteBuffer sharedMessageBuffer = Utils.createSubBuffer(bb, dataTypeSize);
                    this.dataType = this.readSharedMessage(sharedMessageBuffer, hdfBackingStorage, DataTypeMessage.class).getDataType();
                } else {
                    this.dataType = DataType.readDataType(Utils.createSubBuffer(bb, dataTypeSize));
                }
                if (flags.get(1)) {
                    ByteBuffer sharedMessageBuffer = Utils.createSubBuffer(bb, dataSpaceSize);
                    this.dataSpace = this.readSharedMessage(sharedMessageBuffer, hdfBackingStorage, DataSpaceMessage.class).getDataSpace();
                    break;
                }
                this.dataSpace = DataSpace.readDataSpace(Utils.createSubBuffer(bb, dataSpaceSize), hdfBackingStorage.getSuperblock());
                break;
            }
            default: {
                throw new UnsupportedHdfException("Unsupported Attribute message version. Detected version: " + this.version);
            }
        }
        int dataSize = Math.toIntExact(this.dataSpace.getTotalLength() * (long)this.dataType.getSize());
        this.data = dataSize == 0 ? null : Utils.createSubBuffer(bb, dataSize);
        logger.debug("Read attribute: Name=[{}] Datatype=[{}], Dataspace[{}]", this.name, this.dataType, this.dataSpace);
    }

    private <T extends Message> T readSharedMessage(ByteBuffer sharedMessageBuffer, HdfBackingStorage hdfBackingStorage, Class<T> messageType) {
        SharedMessage sharedMessage = new SharedMessage(sharedMessageBuffer, hdfBackingStorage.getSuperblock());
        ObjectHeader objectHeader = ObjectHeader.readObjectHeader(hdfBackingStorage, sharedMessage.getObjectHeaderAddress());
        return objectHeader.getMessageOfType(messageType);
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public DataSpace getDataSpace() {
        return this.dataSpace;
    }

    public ByteBuffer getDataBuffer() {
        if (this.data == null) {
            return null;
        }
        return this.data.slice().order(this.data.order());
    }

    public String toString() {
        return "AttributeMessage [name=" + this.name + ", dataType=" + this.dataType + ", dataSpace=" + this.dataSpace + "]";
    }

    @Override
    public int getMessageType() {
        return 12;
    }

    public static AttributeMessage create(String name, Attribute attribute) {
        return new AttributeMessage(name, attribute.getDataSpace(), attribute.getDataType(), attribute.getData());
    }

    private AttributeMessage(String name, DataSpace dataSpace, DataType dataType, Object data) {
        this.name = name;
        this.version = (byte)3;
        this.dataSpace = dataSpace;
        this.dataType = dataType;
        this.data = dataType.encodeData(data);
    }

    @Override
    public ByteBuffer toBuffer() {
        byte[] nameBytes = this.name.getBytes(StandardCharsets.UTF_8);
        ByteBuffer dataTypeBytes = this.dataType.toBuffer();
        ByteBuffer dataSpaceBytes = this.dataSpace.toBuffer();
        return new BufferBuilder().writeByte(3).writeByte(0).writeShort(nameBytes.length + 1).writeShort(dataTypeBytes.capacity()).writeShort(dataSpaceBytes.capacity()).writeByte(1).writeBytes(nameBytes).writeByte(0).writeBuffer(dataTypeBytes).writeBuffer(dataSpaceBytes).writeBuffer(this.data).build();
    }
}

