/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.BufferBuilder;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class FillValueMessage
extends Message {
    public static final int MESSAGE_TYPE = 5;
    private static final int FILL_VALUE_DEFINED_BIT = 5;
    private final int spaceAllocationTime;
    private final int fillValueWriteTime;
    private final boolean fillValueDefined;
    private final ByteBuffer fillValue;
    public static final FillValueMessage NO_FILL = new FillValueMessage(1, 0, false, null);

    FillValueMessage(ByteBuffer bb, BitSet messageFlags) {
        super(messageFlags);
        byte version = bb.get();
        if (version == 1 || version == 2) {
            boolean fillValueMaybeDefined;
            this.spaceAllocationTime = bb.get();
            this.fillValueWriteTime = bb.get();
            boolean bl = fillValueMaybeDefined = bb.get() == 1;
            if (version == 2 && fillValueMaybeDefined) {
                int size = Utils.readBytesAsUnsignedInt(bb, 4);
                if (size > 0) {
                    this.fillValue = Utils.createSubBuffer(bb, size);
                    this.fillValueDefined = true;
                } else {
                    this.fillValue = null;
                    this.fillValueDefined = false;
                }
            } else {
                this.fillValue = null;
                this.fillValueDefined = false;
            }
        } else if (version == 3) {
            BitSet flags = BitSet.valueOf(new byte[]{bb.get()});
            this.spaceAllocationTime = Utils.bitsToInt(flags, 0, 2);
            this.fillValueWriteTime = Utils.bitsToInt(flags, 2, 2);
            this.fillValueDefined = flags.get(5);
            if (this.fillValueDefined) {
                int size = Utils.readBytesAsUnsignedInt(bb, 4);
                this.fillValue = Utils.createSubBuffer(bb, size);
            } else {
                this.fillValue = null;
            }
        } else {
            throw new HdfException("Unrecognized version = " + version);
        }
    }

    private FillValueMessage(int spaceAllocationTime, int fillValueWriteTime, boolean fillValueDefined, ByteBuffer fillValue) {
        this.spaceAllocationTime = spaceAllocationTime;
        this.fillValueWriteTime = fillValueWriteTime;
        this.fillValueDefined = fillValueDefined;
        this.fillValue = fillValue;
    }

    public boolean isFillValueDefined() {
        return this.fillValueDefined;
    }

    public int getSpaceAllocationTime() {
        return this.spaceAllocationTime;
    }

    public int getFillValueWriteTime() {
        return this.fillValueWriteTime;
    }

    public ByteBuffer getFillValue() {
        return this.fillValue.asReadOnlyBuffer();
    }

    @Override
    public int getMessageType() {
        return 5;
    }

    @Override
    public ByteBuffer toBuffer() {
        BitSet flags = new BitSet(8);
        Utils.writeIntToBits(this.spaceAllocationTime, flags, 0, 2);
        Utils.writeIntToBits(this.fillValueWriteTime, flags, 2, 2);
        Utils.writeIntToBits(this.fillValueDefined ? 0 : 1, flags, 4, 1);
        Utils.writeIntToBits(this.fillValueDefined ? 1 : 0, flags, 5, 1);
        return new BufferBuilder().writeByte(3).writeBitSet(flags, 1).build();
    }
}

