/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.BufferBuilder;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class GroupInfoMessage
extends Message {
    public static final int MESSAGE_TYPE = 10;
    private static final int LINK_PHASE_CHANGE_PRESENT = 0;
    private static final int ESTIMATED_ENTRY_INFORMATION_PRESENT = 1;
    private final byte version;
    private final BitSet flags;
    private final int maximumCompactLinks;
    private final int minimumDenseLinks;
    private final int estimatedNumberOfEntries;
    private final int estimatedLengthOfEntryName;

    GroupInfoMessage(ByteBuffer bb, BitSet messageFlags) {
        super(messageFlags);
        this.version = bb.get();
        if (this.version != 0) {
            throw new HdfException("Unrecognized version " + this.version);
        }
        this.flags = BitSet.valueOf(new byte[]{bb.get()});
        if (this.flags.get(0)) {
            this.maximumCompactLinks = Utils.readBytesAsUnsignedInt(bb, 2);
            this.minimumDenseLinks = Utils.readBytesAsUnsignedInt(bb, 2);
        } else {
            this.maximumCompactLinks = -1;
            this.minimumDenseLinks = -1;
        }
        if (this.flags.get(1)) {
            this.estimatedNumberOfEntries = Utils.readBytesAsUnsignedInt(bb, 2);
            this.estimatedLengthOfEntryName = Utils.readBytesAsUnsignedInt(bb, 2);
        } else {
            this.estimatedNumberOfEntries = -1;
            this.estimatedLengthOfEntryName = -1;
        }
    }

    public int getMaximumCompactLinks() {
        return this.maximumCompactLinks;
    }

    public int getMinimumDenseLinks() {
        return this.minimumDenseLinks;
    }

    public int getEstimatedNumberOfEntries() {
        return this.estimatedNumberOfEntries;
    }

    public int getEstimatedLengthOfEntryName() {
        return this.estimatedLengthOfEntryName;
    }

    @Override
    public int getMessageType() {
        return 10;
    }

    @Override
    public ByteBuffer toBuffer() {
        BufferBuilder bufferBuilder = new BufferBuilder();
        bufferBuilder.writeByte(this.version);
        bufferBuilder.writeBitSet(this.flags, 1);
        if (this.flags.get(0)) {
            bufferBuilder.writeShort(this.maximumCompactLinks);
            bufferBuilder.writeShort(this.minimumDenseLinks);
        }
        if (this.flags.get(1)) {
            bufferBuilder.writeShort(this.estimatedNumberOfEntries);
            bufferBuilder.writeShort(this.estimatedLengthOfEntryName);
        }
        return bufferBuilder.build();
    }

    private GroupInfoMessage() {
        super(new BitSet(1));
        this.flags = new BitSet(1);
        this.version = 0;
        this.maximumCompactLinks = -1;
        this.minimumDenseLinks = -1;
        this.estimatedNumberOfEntries = -1;
        this.estimatedLengthOfEntryName = -1;
    }

    public static GroupInfoMessage createBasic() {
        return new GroupInfoMessage();
    }
}

