/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.BitSet;

public class OldObjectModificationTimeMessage
extends Message {
    public static final int MESSAGE_TYPE = 14;
    final LocalDateTime modificationTime;

    public OldObjectModificationTimeMessage(ByteBuffer bb, BitSet flags) {
        super(flags);
        ByteBuffer yearBuffer = Utils.createSubBuffer(bb, 4);
        int year = Integer.parseInt(StandardCharsets.US_ASCII.decode(yearBuffer).toString());
        ByteBuffer monthBuffer = Utils.createSubBuffer(bb, 2);
        int month = Integer.parseInt(StandardCharsets.US_ASCII.decode(monthBuffer).toString());
        ByteBuffer dayBuffer = Utils.createSubBuffer(bb, 2);
        int day = Integer.parseInt(StandardCharsets.US_ASCII.decode(dayBuffer).toString());
        ByteBuffer hourBuffer = Utils.createSubBuffer(bb, 2);
        int hour = Integer.parseInt(StandardCharsets.US_ASCII.decode(hourBuffer).toString());
        ByteBuffer minuteBuffer = Utils.createSubBuffer(bb, 2);
        int minute = Integer.parseInt(StandardCharsets.US_ASCII.decode(minuteBuffer).toString());
        ByteBuffer secondBuffer = Utils.createSubBuffer(bb, 2);
        int second = Integer.parseInt(StandardCharsets.US_ASCII.decode(secondBuffer).toString());
        bb.position(bb.position() + 2);
        this.modificationTime = LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public LocalDateTime getModifiedTime() {
        return this.modificationTime;
    }

    @Override
    public int getMessageType() {
        return 14;
    }
}

