/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.BufferBuilder;
import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class SymbolTableMessage
extends Message {
    public static final int MESSAGE_TYPE = 17;
    private final long bTreeAddress;
    private final long localHeapAddress;

    SymbolTableMessage(ByteBuffer bb, Superblock sb, BitSet flags) {
        super(flags);
        this.bTreeAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
        this.localHeapAddress = Utils.readBytesAsUnsignedLong(bb, sb.getSizeOfOffsets());
    }

    public SymbolTableMessage(BitSet flags, long bTreeAddress, long localHeapAddress) {
        super(flags);
        this.bTreeAddress = bTreeAddress;
        this.localHeapAddress = localHeapAddress;
    }

    @Override
    public ByteBuffer toBuffer() {
        return new BufferBuilder().writeBytes(super.flagsToBytes()).writeLong(this.bTreeAddress).writeLong(this.localHeapAddress).build();
    }

    public long getBTreeAddress() {
        return this.bTreeAddress;
    }

    public long getLocalHeapAddress() {
        return this.localHeapAddress;
    }

    @Override
    public int getMessageType() {
        return 17;
    }
}

