/*
 * Decompiled with CFR 0.152.
 */
package jsc.distributions;

import jsc.descriptive.Tally;
import jsc.distributions.AbstractDistribution;
import jsc.distributions.Beta;
import jsc.distributions.Distribution;
import jsc.distributions.Poisson;
import jsc.goodnessfit.ChiSquaredFitTest;
import jsc.util.Maths;

public class NegativeBinomial
extends AbstractDistribution {
    private long n;
    private double p;
    private Poisson poisson;
    private double LOG1MP;
    private double LOGP;

    public NegativeBinomial(long l, double d) {
        if (l < 1L || d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid distribution parameter.");
        }
        this.n = l;
        this.p = d;
        this.poisson = new Poisson((double)l * (1.0 - d) / d);
        this.LOG1MP = Math.log(1.0 - d);
        this.LOGP = Math.log(d);
    }

    public double cdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return Beta.incompleteBeta(this.p, this.n, d + 1.0, Maths.lnB(this.n, d + 1.0));
    }

    public long getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    public double inverseCdf(double d) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("Invalid probability.");
        }
        double d2 = 0.0;
        d2 = this.poisson.inverseCdf(d);
        double d3 = this.cdf(d2);
        while (d3 > d && d2 > 0.0) {
            d3 = this.cdf(d2 -= 1.0);
        }
        while (d3 < d) {
            d3 = this.cdf(d2 += 1.0);
        }
        return d2;
    }

    public boolean isDiscrete() {
        return true;
    }

    public double mean() {
        return (double)this.n * (1.0 - this.p) / this.p;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Invalid variate-value.");
        }
        return Math.exp(Maths.logBinomialCoefficient((long)((double)this.n + d - 1.0), (long)d) + (double)this.n * this.LOGP + d * this.LOG1MP);
    }

    public double random() {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (this.p > 0.6) {
            do {
                if (this.rand.nextDouble() < this.p) {
                    ++n;
                    continue;
                }
                d += 1.0;
            } while ((long)n < this.n);
            return d;
        }
        int n2 = 1;
        while ((long)n2 <= this.n) {
            d2 += Math.ceil(Math.log(1.0 - this.rand.nextDouble()) / this.LOG1MP);
            ++n2;
        }
        return Math.max(0.0, Math.floor(d2 - (double)this.n));
    }

    public String toString() {
        return new String("Negative binomial distribution: n = " + this.n + ", p = " + this.p + ".");
    }

    public double variance() {
        return (double)this.n * (1.0 - this.p) / (this.p * this.p);
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            long l = 40L;
            double d = 0.9;
            NegativeBinomial negativeBinomial = new NegativeBinomial(l, d);
            negativeBinomial = new NegativeBinomial(10L, 0.4);
            int n = 10000;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = (int)negativeBinomial.random();
                ++n2;
            }
            ChiSquaredFitTest chiSquaredFitTest = new ChiSquaredFitTest(new Tally(nArray), (Distribution)negativeBinomial, 0);
            System.out.println("All E > 5 " + chiSquaredFitTest.poolBins());
            System.out.println("m = " + n + " Chi-squared = " + chiSquaredFitTest.getTestStatistic() + " SP = " + chiSquaredFitTest.getSP());
        }
    }
}

