/*
 * Decompiled with CFR 0.152.
 */
package jsc.goodnessfit;

import jsc.util.Arrays;
import jsc.util.Sort;

public class SampleDistributionFunction {
    private int n;
    private double[] x;
    private double[] S;
    private double[] orderedX;
    private double[] orderedS;

    public SampleDistributionFunction(double[] dArray) {
        this.n = dArray.length;
        if (this.n < 2) {
            throw new IllegalArgumentException("Less than 2 observations.");
        }
        this.x = dArray;
        this.orderedX = new double[this.n];
        this.S = new double[this.n];
        this.orderedS = new double[this.n];
        int[] nArray = Arrays.sequence(this.n);
        System.arraycopy(dArray, 0, this.orderedX, 0, this.n);
        Sort.sort(this.orderedX, nArray, 0, this.n - 1, true);
        this.orderedS[this.n - 1] = 1.0;
        int n = this.n - 2;
        while (n >= 0) {
            this.orderedS[n] = this.orderedX[n] == this.orderedX[n + 1] ? this.orderedS[n + 1] : (1.0 + (double)n) / (double)this.n;
            --n;
        }
        n = 0;
        while (n < this.n) {
            this.S[nArray[n]] = this.orderedS[n];
            ++n;
        }
    }

    public double getMinX() {
        return this.orderedX[0];
    }

    public double getMaxX() {
        return this.orderedX[this.n - 1];
    }

    public int getN() {
        return this.n;
    }

    public double getS(int n) {
        return this.S[n];
    }

    public double getX(int n) {
        return this.x[n];
    }

    public double getOrderedS(int n) {
        return this.orderedS[n];
    }

    public double getOrderedX(int n) {
        return this.orderedX[n];
    }

    public double[] getS() {
        return this.S;
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getOrderedS() {
        return this.orderedS;
    }

    public double[] getOrderedX() {
        return this.orderedX;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nSample distribution function\n");
        stringBuffer.append("x\tS(x)");
        int n = 0;
        while (n < this.getN()) {
            stringBuffer.append("\n" + this.getOrderedX(n) + "\t" + this.getOrderedS(n));
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{72.2, 64.0, 53.4, 76.8, 86.3, 58.1, 63.2, 73.1, 78.0, 44.3, 85.1, 66.6, 80.4, 76.0, 68.8, 76.8, 58.9, 58.1, 74.9, 72.2, 73.1, 39.3, 52.8, 54.2, 65.3, 74.0, 63.2, 64.7, 68.8, 85.1, 62.2, 76.0, 70.5, 48.9, 78.0, 66.6, 58.1, 32.5, 63.2, 64.0, 68.8, 65.3, 71.9, 72.2, 63.2, 72.2, 70.5, 80.4, 45.4, 59.6};
            SampleDistributionFunction sampleDistributionFunction = new SampleDistributionFunction(dArray);
            System.out.println(sampleDistributionFunction.toString());
        }
    }
}

