/*
 * Decompiled with CFR 0.152.
 */
package jsc.independentsamples;

import jsc.ci.ConfidenceInterval;
import jsc.combinatorics.Enumerator;
import jsc.combinatorics.MultiSetPermutations;
import jsc.descriptive.MeanVar;
import jsc.distributions.StudentsT;
import jsc.independentsamples.PermutableTwoSampleStatistic;
import jsc.independentsamples.TwoSampleStatistic;
import jsc.tests.H1;
import jsc.tests.SignificanceTest;

public class TwoSampleTtest
extends PermutableTwoSampleStatistic
implements TwoSampleStatistic,
SignificanceTest,
ConfidenceInterval {
    private final boolean sameVar;
    private final double d;
    private final double df;
    private final double s;
    private final double t;
    private final MeanVar mvA;
    private final MeanVar mvB;
    private final double SP;
    private double confidenceCoeff;
    private double lowerLimit;
    private double upperLimit;
    private final double[] xA;
    private final double[] xB;

    public TwoSampleTtest(double[] dArray, double[] dArray2, H1 h1, boolean bl, double d) {
        super(dArray, dArray2);
        double d2;
        this.sameVar = bl;
        this.xA = dArray;
        this.xB = dArray2;
        this.mvA = new MeanVar(dArray);
        this.mvB = new MeanVar(dArray2);
        int n = this.mvA.getN();
        int n2 = this.mvB.getN();
        if (bl) {
            this.df = n + n2 - 2;
            d2 = ((double)(n - 1) * this.mvA.getVariance() + (double)(n2 - 1) * this.mvB.getVariance()) / this.df;
            this.s = Math.sqrt(d2 * (1.0 / (double)n + 1.0 / (double)n2));
        } else {
            d2 = this.mvA.getVariance() / (double)n;
            double d3 = this.mvB.getVariance() / (double)n2;
            this.df = Math.floor((d2 + d3) * (d2 + d3) / (d2 * d2 / (double)(n - 1) + d3 * d3 / (double)(n2 - 1)));
            this.s = Math.sqrt(d2 + d3);
        }
        this.d = this.mvA.getMean() - this.mvB.getMean();
        this.t = this.d / this.s;
        d2 = StudentsT.tailProb(this.t, this.df);
        this.SP = h1 == H1.NOT_EQUAL ? d2 + d2 : (h1 == H1.LESS_THAN ? (this.t < 0.0 ? d2 : 1.0 - d2) : (this.t > 0.0 ? d2 : 1.0 - d2));
        this.setConfidenceCoeff(d);
    }

    public TwoSampleTtest(double[] dArray, double[] dArray2, H1 h1, boolean bl) {
        this(dArray, dArray2, h1, bl, 0.95);
    }

    public TwoSampleTtest(double[] dArray, double[] dArray2, boolean bl) {
        this(dArray, dArray2, H1.NOT_EQUAL, bl);
    }

    public TwoSampleTtest(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, H1.NOT_EQUAL, false);
    }

    public double resampleStatistic(double[] dArray, double[] dArray2) {
        double d;
        MeanVar meanVar = new MeanVar(dArray);
        MeanVar meanVar2 = new MeanVar(dArray2);
        int n = meanVar.getN();
        int n2 = meanVar2.getN();
        if (this.sameVar) {
            double d2 = ((double)(n - 1) * meanVar.getVariance() + (double)(n2 - 1) * meanVar2.getVariance()) / this.df;
            d = Math.sqrt(d2 * (1.0 / (double)n + 1.0 / (double)n2));
        } else {
            double d3 = meanVar.getVariance() / (double)n;
            double d4 = meanVar2.getVariance() / (double)n2;
            d = Math.sqrt(d3 + d4);
        }
        double d5 = (meanVar.getMean() - meanVar2.getMean()) / d;
        return d5;
    }

    public double getDf() {
        return this.df;
    }

    public Enumerator getEnumerator() {
        int[] nArray = new int[]{this.mvA.getN(), this.mvB.getN()};
        return new MultiSetPermutations(nArray);
    }

    public double getMeanA() {
        return this.mvA.getMean();
    }

    public double getMeanB() {
        return this.mvB.getMean();
    }

    public double getMeanDiff() {
        return this.d;
    }

    public double[] getSampleA() {
        return this.xA;
    }

    public double[] getSampleB() {
        return this.xB;
    }

    public double getSdA() {
        return this.mvA.getSd();
    }

    public double getSdB() {
        return this.mvB.getSd();
    }

    public double getSdDiff() {
        return this.s;
    }

    public int sizeA() {
        return this.mvA.getN();
    }

    public int sizeB() {
        return this.mvB.getN();
    }

    public double getSP() {
        return this.SP;
    }

    public double getStatistic() {
        return this.t;
    }

    public double getTestStatistic() {
        return this.t;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public double getUpperLimit() {
        return this.upperLimit;
    }

    public double getConfidenceCoeff() {
        return this.confidenceCoeff;
    }

    public void setConfidenceCoeff(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid confidence coefficient.");
        }
        this.confidenceCoeff = d;
        StudentsT studentsT = new StudentsT(this.df);
        double d2 = studentsT.inverseCdf(0.5 + 0.5 * d);
        double d3 = d2 * this.s;
        this.lowerLimit = this.d - d3;
        this.upperLimit = this.d + d3;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            double[] dArray = new double[]{90.0, 72.0, 61.0, 66.0, 81.0, 69.0, 59.0, 70.0};
            double[] dArray2 = new double[]{62.0, 85.0, 78.0, 66.0, 80.0, 91.0, 69.0, 77.0, 84.0};
            TwoSampleTtest twoSampleTtest = new TwoSampleTtest(dArray, dArray2);
            System.out.println("H1: means not equal: t = " + twoSampleTtest.getTestStatistic() + " SP = " + twoSampleTtest.getSP());
            System.out.println("CI = [" + twoSampleTtest.getLowerLimit() + ", " + twoSampleTtest.getUpperLimit() + "]");
            TwoSampleTtest twoSampleTtest2 = new TwoSampleTtest(dArray, dArray2, H1.LESS_THAN, false);
            System.out.println("H1: mean A < mean B: t = " + twoSampleTtest2.getTestStatistic() + " SP = " + twoSampleTtest2.getSP());
            System.out.println("CI = [" + twoSampleTtest2.getLowerLimit() + ", " + twoSampleTtest2.getUpperLimit() + "]");
            TwoSampleTtest twoSampleTtest3 = new TwoSampleTtest(dArray, dArray2, H1.GREATER_THAN, false);
            System.out.println("H1: mean A > mean B: t = " + twoSampleTtest3.getTestStatistic() + " SP = " + twoSampleTtest3.getSP());
            System.out.println("CI = [" + twoSampleTtest3.getLowerLimit() + ", " + twoSampleTtest3.getUpperLimit() + "]");
        }
    }
}

