/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import jsc.ci.AbstractConfidenceInterval;
import jsc.distributions.FishersF;

public class ProportionCI
extends AbstractConfidenceInterval {
    public ProportionCI(long l, long l2, double d) {
        super(d);
        double d2;
        FishersF fishersF;
        double d3;
        if (l2 < 1L) {
            throw new IllegalArgumentException("Invalid number of trials.");
        }
        if (l < 0L || l > l2) {
            throw new IllegalArgumentException("Invalid number of successes.");
        }
        double d4 = 1.0 - d;
        if (l > 0L) {
            d3 = l2 - l + 1L;
            fishersF = new FishersF(l + l, d3 + d3);
            d2 = fishersF.inverseCdf(0.5 * d4);
            this.lowerLimit = 1.0 / (1.0 + d3 / ((double)l * d2));
        } else {
            this.lowerLimit = 0.0;
        }
        d3 = l2 - l;
        if (d3 > 0.0) {
            fishersF = new FishersF(2L * (l + 1L), d3 + d3);
            d2 = fishersF.inverseCdf(1.0 - 0.5 * d4);
            this.upperLimit = 1.0 / (1.0 + d3 / ((double)(l + 1L) * d2));
        } else {
            this.upperLimit = 1.0;
        }
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            ProportionCI proportionCI = new ProportionCI(1L, 1000L, 0.95);
            System.out.println("CI = [" + proportionCI.getLowerLimit() + ", " + proportionCI.getUpperLimit() + "]");
        }
    }
}

