/*
 * Decompiled with CFR 0.152.
 */
package jsc.onesample;

import java.util.Arrays;
import jsc.ci.AbstractConfidenceInterval;
import jsc.datastructures.PairedData;
import jsc.distributions.Binomial;
import jsc.util.Maths;

public class SignMedianCI
extends AbstractConfidenceInterval {
    int d;
    double achievedConfidence;
    double median;

    public SignMedianCI(double[] dArray, double d) {
        super(d);
        int n = dArray.length;
        if (n < 2) {
            throw new IllegalArgumentException("Less than two values.");
        }
        Binomial binomial = new Binomial((long)n, 0.5);
        this.d = (int)binomial.inverseCdf(0.5 - d / 2.0);
        if (this.d < 1 || this.d > n) {
            throw new IllegalArgumentException("Cannot calculate interval.");
        }
        double d2 = binomial.cdf(this.d - 1);
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, n);
        Arrays.sort(dArray2);
        this.lowerLimit = dArray2[this.d - 1];
        this.upperLimit = dArray2[n - this.d];
        int n2 = n / 2;
        this.median = n % 2 == 0 ? (dArray2[n2 - 1] + dArray2[n2]) / 2.0 : dArray2[n2];
        this.achievedConfidence = 1.0 - 2.0 * d2;
    }

    public SignMedianCI(PairedData pairedData, double d) {
        this(pairedData.differences(), d);
    }

    public double getAchievedConfidence() {
        return this.achievedConfidence;
    }

    public int getD() {
        return this.d;
    }

    public double getMedian() {
        return this.median;
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            long l = System.currentTimeMillis();
            double[] dArray = new double[]{5.0, 3.0, -1.0, 14.0, 7.0, -4.0, 11.0, 10.0};
            int n = dArray.length;
            SignMedianCI signMedianCI = new SignMedianCI(dArray, 0.92);
            long l2 = System.currentTimeMillis();
            System.out.println("n = " + n + " Time = " + (l2 - l) / 1000L + " secs");
            System.out.println("CI = [" + signMedianCI.getLowerLimit() + ", " + signMedianCI.getUpperLimit() + "]" + " d = " + signMedianCI.getD() + " Median = " + signMedianCI.getMedian() + " Achieved confidence = " + signMedianCI.getAchievedConfidence());
            double[] dArray2 = new double[]{51.0, 48.0, 52.0, 62.0, 64.0, 51.0, 55.0, 60.0};
            double[] dArray3 = new double[]{46.0, 45.0, 53.0, 48.0, 57.0, 55.0, 44.0, 50.0};
            double[] dArray4 = new double[]{0.89, 0.9, 0.92, 0.94, 0.95, 0.96, 0.98, 0.99};
            PairedData pairedData = new PairedData(dArray2, dArray3);
            System.out.println("************* Suntan lotions: n = 8 *******************");
            int n2 = 0;
            while (n2 < dArray4.length) {
                System.out.println("Nominal confidence coeff. = " + dArray4[n2]);
                signMedianCI = new SignMedianCI(pairedData, dArray4[n2]);
                System.out.println("Exact CI=[" + signMedianCI.getLowerLimit() + "," + signMedianCI.getUpperLimit() + "]" + " d=" + signMedianCI.getD() + " Achieved conf.=" + Maths.round(signMedianCI.getAchievedConfidence(), 3));
                ++n2;
            }
            double[] dArray5 = new double[]{54.5, 70.6, 85.6, 78.2, 69.6, 73.1, 97.5, 85.6, 74.9, 86.8, 53.6, 89.4};
            double[] dArray6 = new double[]{55.5, 72.9, 84.8, 78.3, 71.6, 74.0, 97.2, 88.0, 74.4, 89.3, 52.3, 91.5};
            pairedData = new PairedData(dArray5, dArray6);
            System.out.println("*************** Weight change data: n = 12 ***************");
            n2 = 0;
            while (n2 < dArray4.length) {
                System.out.println("Nominal confidence coeff. = " + dArray4[n2]);
                signMedianCI = new SignMedianCI(pairedData, dArray4[n2]);
                System.out.println(" Exact CI=[" + signMedianCI.getLowerLimit() + "," + signMedianCI.getUpperLimit() + "]" + " d=" + signMedianCI.getD() + " Achieved conf.=" + Maths.round(signMedianCI.getAchievedConfidence(), 3));
                signMedianCI = new SignMedianCI(pairedData, dArray4[n2]);
                System.out.println("Approx CI=[" + signMedianCI.getLowerLimit() + "," + signMedianCI.getUpperLimit() + "]" + " d=" + signMedianCI.getD() + " Achieved conf.=" + Maths.round(signMedianCI.getAchievedConfidence(), 3));
                ++n2;
            }
        }
    }
}

