/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.control;

import java.awt.Color;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class PosIntegerField
extends JTextField {
    private Toolkit toolkit;
    private NumberFormat integerFormatter;
    int maxDigits;
    int maxValue;

    public PosIntegerField(int n, int n2) {
        this(n, n2, 9, 999999999);
    }

    public PosIntegerField(int n, int n2, int n3, int n4) {
        super(n2);
        this.maxDigits = n3;
        this.maxValue = n4;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.integerFormatter = NumberFormat.getNumberInstance(Locale.UK);
        this.integerFormatter.setParseIntegerOnly(true);
        this.integerFormatter.setGroupingUsed(false);
        this.setBackground(Color.white);
        this.setValue(n);
    }

    public int getValue() {
        int n = 0;
        try {
            n = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException parseException) {
            this.toolkit.beep();
        }
        if (n > this.maxValue || n < 0) {
            n = this.maxValue;
            this.setText(new Integer(this.maxValue).toString());
        }
        return n;
    }

    public void setValue(int n) {
        this.setText(this.integerFormatter.format(n));
    }

    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.getLength() + string.length() > PosIntegerField.this.maxDigits) {
                PosIntegerField.this.toolkit.beep();
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < cArray2.length) {
                if (Character.isDigit(cArray[n3])) {
                    cArray2[n2++] = cArray[n3];
                } else {
                    PosIntegerField.this.toolkit.beep();
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }
    }
}

