/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.plot2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import jsc.swt.plot2d.PlotObject;
import jsc.swt.virtualgraphics.VirtualTransform;

public class PlotShape
implements PlotObject {
    static Color defaultColour = Color.black;
    static Paint defaultPaint = Color.black;
    static Stroke defaultStroke = new BasicStroke();
    Shape shape;
    Color colour;
    Paint paint;
    Stroke stroke;
    boolean filled;

    public PlotShape(Shape shape) {
        this.shape = shape;
        this.colour = defaultColour;
        this.stroke = defaultStroke;
        this.paint = defaultPaint;
        this.filled = false;
    }

    public PlotShape(Shape shape, Color color) {
        this.shape = shape;
        this.colour = color;
        this.stroke = defaultStroke;
        this.paint = color;
        this.filled = false;
    }

    public PlotShape(Shape shape, Paint paint) {
        this.shape = shape;
        this.colour = defaultColour;
        this.stroke = defaultStroke;
        this.paint = paint;
        this.filled = true;
    }

    public PlotShape(Shape shape, Color color, Stroke stroke) {
        this.shape = shape;
        this.colour = color;
        this.stroke = stroke;
        this.paint = color;
        this.filled = false;
    }

    public PlotShape(Shape shape, Color color, Stroke stroke, Paint paint, boolean bl) {
        this.shape = shape;
        this.colour = color;
        this.stroke = stroke;
        this.paint = paint;
        this.filled = bl;
    }

    public Object clone() {
        return this.copy();
    }

    public boolean contains(Point2D point2D, VirtualTransform virtualTransform) {
        return virtualTransform.createTransformedShape(this.stroke.createStrokedShape(this.shape)).contains(point2D);
    }

    public PlotShape copy() {
        PlotShape plotShape = new PlotShape(this.shape, this.colour, this.stroke, this.paint, this.filled);
        return plotShape;
    }

    public void draw(Graphics2D graphics2D, VirtualTransform virtualTransform) {
        graphics2D.setColor(this.colour);
        graphics2D.setStroke(this.stroke);
        graphics2D.setPaint(this.paint);
        if (this.filled) {
            graphics2D.fill(virtualTransform.createTransformedShape(this.shape));
        } else {
            graphics2D.draw(virtualTransform.createTransformedShape(this.shape));
        }
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color color) {
        this.colour = color;
        this.paint = color;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public static void setDefaultColour(Color color) {
        defaultColour = color;
    }

    public static void setDefaultPaint(Paint paint) {
        defaultPaint = paint;
    }

    public static void setDefaultStroke(Stroke stroke) {
        defaultStroke = stroke;
    }
}

