/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertiesFile
extends Properties {
    String fileName = "";

    public PropertiesFile() {
    }

    public PropertiesFile(String string) {
        this.fileName = string;
    }

    public PropertiesFile(String string, Properties properties) {
        super(properties);
        this.fileName = string;
    }

    public boolean getBoolProperty(String string) {
        return this.getBoolProperty(string, false);
    }

    public boolean getBoolProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("TRUE");
    }

    public double getDoubleProperty(String string) {
        return this.getDoubleProperty(string, 0.0);
    }

    public double getDoubleProperty(String string, double d) {
        String string2 = this.getProperty(string);
        try {
            return new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public int getIntProperty(String string) {
        return this.getIntProperty(string, 0);
    }

    public int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string);
        try {
            return new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getLongProperty(String string) {
        return this.getLongProperty(string, 0L);
    }

    public long getLongProperty(String string, long l) {
        String string2 = this.getProperty(string);
        try {
            return new Long(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public boolean load() {
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(this.fileName));
            this.load(dataInputStream);
            dataInputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean load(String string) {
        this.fileName = string;
        return this.load();
    }

    public boolean save(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.fileName));
            this.store(dataOutputStream, string);
            dataOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean save(String string, String string2) {
        this.fileName = string;
        return this.save(string2);
    }

    public void setProperty(String string, boolean bl) {
        String string2 = "FALSE";
        if (bl) {
            string2 = "TRUE";
        }
        this.setProperty(string, string2);
    }

    public void setProperty(String string, int n) {
        this.setProperty(string, Integer.toString(n));
    }

    public void setProperty(String string, long l) {
        this.setProperty(string, Long.toString(l));
    }

    public void setProperty(String string, double d) {
        this.setProperty(string, Double.toString(d));
    }

    static class Test {
        Test() {
        }

        public static void main(String[] stringArray) {
            PropertiesFile propertiesFile = new PropertiesFile();
            propertiesFile.setProperty("Boolean", true);
            propertiesFile.setProperty("Int", -1);
            propertiesFile.setProperty("Long", -1);
            propertiesFile.setProperty("Double", Math.E);
            PropertiesFile propertiesFile2 = new PropertiesFile("C:\\WINDOWS\\TEST.PRO", propertiesFile);
            propertiesFile2.load();
            System.out.println(propertiesFile2.getBoolProperty("Boolean"));
            System.out.println(propertiesFile2.getIntProperty("Int"));
            System.out.println(propertiesFile2.getLongProperty("Long"));
            System.out.println(propertiesFile2.getDoubleProperty("Double"));
            propertiesFile2.setProperty("Boolean", true);
            propertiesFile2.setProperty("Int", 42);
            propertiesFile2.setProperty("Long", 666);
            propertiesFile2.setProperty("Double", Math.PI);
            propertiesFile2.save("Test properties");
        }
    }
}

