/*
 * Decompiled with CFR 0.152.
 */
package jsc.swt.virtualgraphics;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import jsc.swt.virtualgraphics.VDimension;
import jsc.swt.virtualgraphics.VPoint;
import jsc.swt.virtualgraphics.VRectangle;

public class VirtualTransform
extends AffineTransform {
    public VirtualTransform(VRectangle vRectangle, Dimension dimension) {
        this.scale((double)dimension.width / vRectangle.width, (double)(-dimension.height) / vRectangle.height);
        this.translate(-vRectangle.x, -vRectangle.y - vRectangle.height);
    }

    public VDimension pixelToVirtual(Dimension dimension) {
        double d = this.getScaleX();
        double d2 = this.getScaleY();
        if (d == 0.0 || d2 == 0.0) {
            throw new IllegalArgumentException("Zero scale. Probably \"device\" has no size because it has not been painted yet.");
        }
        double d3 = (double)dimension.width / d;
        double d4 = (double)dimension.height / -d2;
        return new VDimension(d3, d4);
    }

    public VPoint pixelToVirtual(Point point) {
        VPoint vPoint = new VPoint(0.0, 0.0);
        try {
            VPoint vPoint2 = (VPoint)this.inverseTransform(point, vPoint);
            return vPoint2;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            System.out.println(noninvertibleTransformException.getMessage());
            return vPoint;
        }
    }
}

