/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.util.Collection;
import jxl.CellReferenceHelper;
import jxl.Range;
import jxl.biff.DVParser;
import jxl.biff.DataValiditySettingsRecord;
import jxl.biff.SheetRangeImpl;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Comment;
import jxl.common.Assert;
import jxl.common.Logger;
import jxl.write.biff.CellValue;

public class BaseCellFeatures {
    public static Logger logger = Logger.getLogger(BaseCellFeatures.class);
    private String comment;
    private double commentWidth;
    private double commentHeight;
    private Comment commentDrawing;
    private ComboBox comboBox;
    private DataValiditySettingsRecord validationSettings;
    private DVParser dvParser;
    private boolean dropDown;
    private boolean dataValidation;
    private CellValue writableCell;
    private static final double defaultCommentWidth = 3.0;
    private static final double defaultCommentHeight = 4.0;
    public static final ValidationCondition BETWEEN = new ValidationCondition(DVParser.BETWEEN);
    public static final ValidationCondition NOT_BETWEEN = new ValidationCondition(DVParser.NOT_BETWEEN);
    public static final ValidationCondition EQUAL = new ValidationCondition(DVParser.EQUAL);
    public static final ValidationCondition NOT_EQUAL = new ValidationCondition(DVParser.NOT_EQUAL);
    public static final ValidationCondition GREATER_THAN = new ValidationCondition(DVParser.GREATER_THAN);
    public static final ValidationCondition LESS_THAN = new ValidationCondition(DVParser.LESS_THAN);
    public static final ValidationCondition GREATER_EQUAL = new ValidationCondition(DVParser.GREATER_EQUAL);
    public static final ValidationCondition LESS_EQUAL = new ValidationCondition(DVParser.LESS_EQUAL);

    protected BaseCellFeatures() {
    }

    public BaseCellFeatures(BaseCellFeatures cf) {
        this.comment = cf.comment;
        this.commentWidth = cf.commentWidth;
        this.commentHeight = cf.commentHeight;
        this.dropDown = cf.dropDown;
        this.dataValidation = cf.dataValidation;
        this.validationSettings = cf.validationSettings;
        if (cf.dvParser != null) {
            this.dvParser = new DVParser(cf.dvParser);
        }
    }

    protected String getComment() {
        return this.comment;
    }

    public double getCommentWidth() {
        return this.commentWidth;
    }

    public double getCommentHeight() {
        return this.commentHeight;
    }

    public final void setWritableCell(CellValue wc) {
        this.writableCell = wc;
    }

    public void setReadComment(String s, double w, double h) {
        this.comment = s;
        this.commentWidth = w;
        this.commentHeight = h;
    }

    public void setValidationSettings(DataValiditySettingsRecord dvsr) {
        Assert.verify(dvsr != null);
        this.validationSettings = dvsr;
        this.dataValidation = true;
    }

    public void setComment(String s) {
        this.setComment(s, 3.0, 4.0);
    }

    public void setComment(String s, double width, double height) {
        this.comment = s;
        this.commentWidth = width;
        this.commentHeight = height;
        if (this.commentDrawing != null) {
            this.commentDrawing.setCommentText(s);
            this.commentDrawing.setWidth(width);
            this.commentDrawing.setWidth(height);
        }
    }

    public void removeComment() {
        this.comment = null;
        if (this.commentDrawing != null) {
            this.writableCell.removeComment(this.commentDrawing);
            this.commentDrawing = null;
        }
    }

    public void removeDataValidation() {
        if (!this.dataValidation) {
            return;
        }
        DVParser dvp = this.getDVParser();
        if (dvp.extendedCellsValidation()) {
            logger.warn("Cannot remove data validation from " + CellReferenceHelper.getCellReference(this.writableCell) + " as it is part of the shared reference " + CellReferenceHelper.getCellReference(dvp.getFirstColumn(), dvp.getFirstRow()) + "-" + CellReferenceHelper.getCellReference(dvp.getLastColumn(), dvp.getLastRow()));
            return;
        }
        this.writableCell.removeDataValidation();
        this.clearValidationSettings();
    }

    public void removeSharedDataValidation() {
        if (!this.dataValidation) {
            return;
        }
        this.writableCell.removeDataValidation();
        this.clearValidationSettings();
    }

    public final void setCommentDrawing(Comment c) {
        this.commentDrawing = c;
    }

    public final Comment getCommentDrawing() {
        return this.commentDrawing;
    }

    public String getDataValidationList() {
        if (this.validationSettings == null) {
            return null;
        }
        return this.validationSettings.getValidationFormula();
    }

    public void setDataValidationList(Collection c) {
        if (this.dataValidation && this.getDVParser().extendedCellsValidation()) {
            logger.warn("Cannot set data validation on " + CellReferenceHelper.getCellReference(this.writableCell) + " as it is part of a shared data validation");
            return;
        }
        this.clearValidationSettings();
        this.dvParser = new DVParser(c);
        this.dropDown = true;
        this.dataValidation = true;
    }

    public void setDataValidationRange(int col1, int r1, int col2, int r2) {
        if (this.dataValidation && this.getDVParser().extendedCellsValidation()) {
            logger.warn("Cannot set data validation on " + CellReferenceHelper.getCellReference(this.writableCell) + " as it is part of a shared data validation");
            return;
        }
        this.clearValidationSettings();
        this.dvParser = new DVParser(col1, r1, col2, r2);
        this.dropDown = true;
        this.dataValidation = true;
    }

    public void setDataValidationRange(String namedRange) {
        if (this.dataValidation && this.getDVParser().extendedCellsValidation()) {
            logger.warn("Cannot set data validation on " + CellReferenceHelper.getCellReference(this.writableCell) + " as it is part of a shared data validation");
            return;
        }
        this.clearValidationSettings();
        this.dvParser = new DVParser(namedRange);
        this.dropDown = true;
        this.dataValidation = true;
    }

    public void setNumberValidation(double val, ValidationCondition c) {
        if (this.dataValidation && this.getDVParser().extendedCellsValidation()) {
            logger.warn("Cannot set data validation on " + CellReferenceHelper.getCellReference(this.writableCell) + " as it is part of a shared data validation");
            return;
        }
        this.clearValidationSettings();
        this.dvParser = new DVParser(val, Double.NaN, c.getCondition());
        this.dropDown = false;
        this.dataValidation = true;
    }

    public void setNumberValidation(double val1, double val2, ValidationCondition c) {
        if (this.dataValidation && this.getDVParser().extendedCellsValidation()) {
            logger.warn("Cannot set data validation on " + CellReferenceHelper.getCellReference(this.writableCell) + " as it is part of a shared data validation");
            return;
        }
        this.clearValidationSettings();
        this.dvParser = new DVParser(val1, val2, c.getCondition());
        this.dropDown = false;
        this.dataValidation = true;
    }

    public boolean hasDataValidation() {
        return this.dataValidation;
    }

    private void clearValidationSettings() {
        this.validationSettings = null;
        this.dvParser = null;
        this.dropDown = false;
        this.comboBox = null;
        this.dataValidation = false;
    }

    public boolean hasDropDown() {
        return this.dropDown;
    }

    public void setComboBox(ComboBox cb) {
        this.comboBox = cb;
    }

    public DVParser getDVParser() {
        if (this.dvParser != null) {
            return this.dvParser;
        }
        if (this.validationSettings != null) {
            this.dvParser = new DVParser(this.validationSettings.getDVParser());
            return this.dvParser;
        }
        return null;
    }

    public void shareDataValidation(BaseCellFeatures source2) {
        if (this.dataValidation) {
            logger.warn("Attempting to share a data validation on cell " + CellReferenceHelper.getCellReference(this.writableCell) + " which already has a data validation");
            return;
        }
        this.clearValidationSettings();
        this.dvParser = source2.getDVParser();
        this.validationSettings = null;
        this.dataValidation = true;
        this.dropDown = source2.dropDown;
        this.comboBox = source2.comboBox;
    }

    public Range getSharedDataValidationRange() {
        if (!this.dataValidation) {
            return null;
        }
        DVParser dvp = this.getDVParser();
        return new SheetRangeImpl(this.writableCell.getSheet(), dvp.getFirstColumn(), dvp.getFirstRow(), dvp.getLastColumn(), dvp.getLastRow());
    }

    protected static class ValidationCondition {
        private DVParser.Condition condition;
        private static ValidationCondition[] types = new ValidationCondition[0];

        ValidationCondition(DVParser.Condition c) {
            this.condition = c;
            ValidationCondition[] oldtypes = types;
            types = new ValidationCondition[oldtypes.length + 1];
            System.arraycopy(oldtypes, 0, types, 0, oldtypes.length);
            ValidationCondition.types[oldtypes.length] = this;
        }

        public DVParser.Condition getCondition() {
            return this.condition;
        }
    }
}

