/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.broad.igv.bbfile.BBFileHeader;
import org.broad.igv.bbfile.BBTotalSummaryBlock;
import org.broad.igv.bbfile.BBZoomLevels;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BigBedIterator;
import org.broad.igv.bbfile.BigWigIterator;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.ZoomLevelIterator;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableFileStream;
import org.broad.tribble.util.SeekableStream;

public class BBFileReader {
    public static final long BBFILE_HEADER_OFFSET = 0L;
    private final String path;
    private final SeekableStream fis;
    private long fileOffset;
    private final BBFileHeader fileHeader;
    private final int dataCount;
    private final boolean isLowToHigh;
    private final int uncompressBufSize;
    private final long autoSqlOffset;
    private String autoSqlFormat;
    private final int zoomLevelCount;
    private long zoomLevelOffset;
    private BBZoomLevels zoomLevels;
    private long mTotalSummaryBlockOffset;
    private BBTotalSummaryBlock totalSummaryBlock;
    private final long chromIDTreeOffset;
    private BPTree chromosomeIDTree;
    private final long chromDataTreeOffset;
    private RPTree chromosomeDataTree;

    public BBFileReader(String path) throws IOException {
        this(path, new SeekableFileStream(new File(path)));
    }

    public BBFileReader(String path, SeekableStream stream) {
        this.path = path;
        this.fis = stream;
        this.fileOffset = 0L;
        this.fileHeader = new BBFileHeader(path, this.fis, this.fileOffset);
        if (!this.fileHeader.isHeaderOK()) {
            throw new RuntimeException("Error reading BBFile header for: " + path);
        }
        this.isLowToHigh = this.fileHeader.isLowToHigh();
        this.uncompressBufSize = this.fileHeader.getUncompressBuffSize();
        this.fileOffset += 64L;
        this.zoomLevelCount = this.fileHeader.getZoomLevels();
        if (this.zoomLevelCount > 0) {
            this.zoomLevelOffset = this.fileOffset;
            this.zoomLevels = new BBZoomLevels(this.fis, this.zoomLevelOffset, this.zoomLevelCount, this.isLowToHigh, this.uncompressBufSize);
            this.fileOffset += (long)this.zoomLevelCount * 24L;
        }
        this.autoSqlOffset = this.fileHeader.getAutoSqlOffset();
        if (this.autoSqlOffset != 0L) {
            // empty if block
        }
        this.fileOffset = this.fileHeader.getTotalSummaryOffset();
        if (this.fileHeader.getVersion() >= 2 && this.fileOffset > 0L) {
            this.totalSummaryBlock = new BBTotalSummaryBlock(this.fis, this.fileOffset, this.isLowToHigh);
            this.fileOffset += 40L;
        }
        this.chromIDTreeOffset = this.fileHeader.getChromosomeTreeOffset();
        if (this.chromIDTreeOffset != 0L) {
            this.fileOffset = this.chromIDTreeOffset;
            this.chromosomeIDTree = new BPTree(this.fis, this.fileOffset, this.isLowToHigh);
        }
        this.chromDataTreeOffset = this.fileHeader.getFullIndexOffset();
        if (this.chromDataTreeOffset != 0L) {
            this.fileOffset = this.chromDataTreeOffset;
            boolean forceDescend = false;
            this.chromosomeDataTree = new RPTree(this.fis, this.fileOffset, this.isLowToHigh, this.uncompressBufSize, forceDescend);
        }
        this.fileOffset = this.fileHeader.getFullDataOffset();
        this.dataCount = this.getDataCount(this.fis, this.fileOffset);
    }

    public String getBBFilePath() {
        return this.path;
    }

    public SeekableStream getBBFis() {
        return this.fis;
    }

    public BBFileHeader getBBFileHeader() {
        return this.fileHeader;
    }

    public boolean isBigBedFile() {
        return this.fileHeader.isBigBed();
    }

    public boolean isBigWigFile() {
        return this.fileHeader.isBigWig();
    }

    public int getDataCount() {
        return this.dataCount;
    }

    public long getChromosomeNameCount() {
        return this.chromosomeIDTree.getItemCount();
    }

    public long getChromosomeRegionCount() {
        return this.chromosomeDataTree.getItemCount();
    }

    public int getDecompressionBufSize() {
        return this.uncompressBufSize;
    }

    public boolean isLowToHigh() {
        return this.isLowToHigh;
    }

    public BBTotalSummaryBlock getTotalSummaryBlock() {
        return this.totalSummaryBlock;
    }

    public BPTree getChromosomeIDTree() {
        return this.chromosomeIDTree;
    }

    public RPTree getChromosomeDataTree() {
        return this.chromosomeDataTree;
    }

    public int getZoomLevelCount() {
        return this.zoomLevelCount;
    }

    public BBZoomLevels getZoomLevels() {
        return this.zoomLevels;
    }

    public RPChromosomeRegion getZoomLevelBounds(int zoomLevel, int startChromID, int endChromID) {
        RPChromosomeRegion chromosomeBounds = this.zoomLevels.getZoomLevelRPTree(zoomLevel).getChromosomeRegion(startChromID, endChromID);
        return chromosomeBounds;
    }

    public RPChromosomeRegion getZoomLevelBounds(int zoomLevel) {
        RPChromosomeRegion chromosomeBounds = this.zoomLevels.getZoomLevelRPTree(zoomLevel).getChromosomeBounds();
        return chromosomeBounds;
    }

    public int getZoomLevelRecordCount(int zoomLevel) {
        return this.zoomLevels.getZoomLevelFormats().get(zoomLevel - 1).getZoomRecordCount();
    }

    public String getChromosomeName(int chromID) {
        String chromosomeName = this.chromosomeIDTree.getChromosomeName(chromID);
        return chromosomeName;
    }

    public ArrayList<String> getChromosomeNames() {
        ArrayList<String> chromosomeList = this.chromosomeIDTree.getChromosomeNames();
        return chromosomeList;
    }

    public int getChromosomeID(String chromosomeKey) {
        int chromosomeID = this.chromosomeIDTree.getChromosomeID(chromosomeKey);
        return chromosomeID;
    }

    public RPChromosomeRegion getChromosomeBounds(int startChromID, int endChromID) {
        RPChromosomeRegion chromosomeBounds = this.chromosomeDataTree.getChromosomeRegion(startChromID, endChromID);
        return chromosomeBounds;
    }

    public RPChromosomeRegion getChromosomeBounds() {
        RPChromosomeRegion chromosomeBounds = this.chromosomeDataTree.getChromosomeBounds();
        return chromosomeBounds;
    }

    public ArrayList<RPChromosomeRegion> getChromosomeRegions() {
        ArrayList<RPChromosomeRegion> regionList = this.chromosomeDataTree.getAllChromosomeRegions();
        return regionList;
    }

    public ArrayList<RPChromosomeRegion> getZoomLevelRegions(int zoomLevel) {
        ArrayList<RPChromosomeRegion> regionList = this.zoomLevels.getZoomLevelRPTree(zoomLevel).getAllChromosomeRegions();
        return regionList;
    }

    public BigBedIterator getBigBedIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigBedFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigBedIterator();
        }
        BigBedIterator bedIterator = new BigBedIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return bedIterator;
    }

    public BigBedIterator getBigBedIterator() {
        if (!this.isBigBedFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.chromosomeDataTree.getChromosomeBounds();
        boolean contained = true;
        BigBedIterator bedIterator = new BigBedIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return bedIterator;
    }

    public BigWigIterator getBigWigIterator(String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (!this.isBigWigFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return new BigWigIterator();
        }
        BigWigIterator wigIterator = new BigWigIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return wigIterator;
    }

    public BigWigIterator getBigWigIterator() {
        if (!this.isBigWigFile()) {
            return null;
        }
        RPChromosomeRegion selectionRegion = this.chromosomeDataTree.getChromosomeBounds();
        boolean contained = true;
        BigWigIterator wigIterator = new BigWigIterator(this.fis, this.chromosomeIDTree, this.chromosomeDataTree, selectionRegion, contained);
        return wigIterator;
    }

    public ZoomLevelIterator getZoomLevelIterator(int zoomLevel, String startChromosome, int startBase, String endChromosome, int endBase, boolean contained) {
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        RPChromosomeRegion selectionRegion = this.getChromosomeBounds(startChromosome, startBase, endChromosome, endBase);
        if (selectionRegion == null) {
            return ZoomLevelIterator.EmptyIterator.theInstance;
        }
        ZoomLevelIterator zoomIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained);
        return zoomIterator;
    }

    public ZoomLevelIterator getZoomLevelIterator(int zoomLevel) {
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        RPChromosomeRegion selectionRegion = zoomDataTree.getChromosomeBounds();
        boolean contained = true;
        ZoomLevelIterator zoomIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained);
        return zoomIterator;
    }

    public ZoomLevelIterator getZoomLevelIterator(int zoomLevel, RPChromosomeRegion selectionRegion, boolean contained) {
        if (zoomLevel < 1 || zoomLevel > this.zoomLevelCount) {
            throw new RuntimeException("Error: ZoomLevelIterator zoom level is out of range\n");
        }
        RPTree zoomDataTree = this.zoomLevels.getZoomLevelRPTree(zoomLevel);
        ZoomLevelIterator zoomIterator = new ZoomLevelIterator(this.fis, this.chromosomeIDTree, zoomDataTree, zoomLevel, selectionRegion, contained);
        return zoomIterator;
    }

    private RPChromosomeRegion getChromosomeBounds(String startChromosome, int startBase, String endChromosome, int endBase) {
        if (startChromosome.length() > this.chromosomeIDTree.getKeySize()) {
            return null;
        }
        String startChromKey = this.chromosomeIDTree.getChromosomeKey(startChromosome);
        int startChromID = this.chromosomeIDTree.getChromosomeID(startChromKey);
        if (startChromID < 0) {
            return null;
        }
        String endChromKey = this.chromosomeIDTree.getChromosomeKey(endChromosome);
        int endChromID = this.chromosomeIDTree.getChromosomeID(endChromKey);
        if (endChromID < 0) {
            return null;
        }
        RPChromosomeRegion chromBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return chromBounds;
    }

    private int getDataCount(SeekableStream fis, long fileOffset) {
        int dataCount;
        LittleEndianInputStream lbdis = null;
        DataInputStream bdis = null;
        byte[] buffer = new byte[4];
        try {
            fis.seek(fileOffset);
            fis.readFully(buffer);
            if (this.isLowToHigh) {
                lbdis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
                dataCount = lbdis.readInt();
            } else {
                bdis = new DataInputStream(new ByteArrayInputStream(buffer));
                dataCount = bdis.readInt();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading data count for all data", ex);
        }
        return dataCount;
    }
}

