/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeChildNodeItem
implements BPTreeNodeItem {
    private final boolean isLeafItem = false;
    private final long itemIndex;
    private final String chromKey;
    private final BPTreeNode childNode;

    public BPTreeChildNodeItem(int itemIndex, String chromKey, BPTreeNode childNode) {
        this.itemIndex = itemIndex;
        this.chromKey = chromKey;
        this.childNode = childNode;
    }

    @Override
    public long getItemIndex() {
        return this.itemIndex;
    }

    @Override
    public boolean isLeafItem() {
        return false;
    }

    @Override
    public String getChromKey() {
        return this.chromKey;
    }

    @Override
    public boolean chromKeysMatch(String chromKey) {
        int thatKeyLength;
        String thisKey = this.chromKey;
        String thatKey = chromKey;
        int thisKeyLength = thisKey.length();
        if (thisKeyLength > (thatKeyLength = thatKey.length())) {
            thisKey = thisKey.substring(0, thatKeyLength);
        } else if (thatKeyLength > thisKeyLength) {
            thatKey = thatKey.substring(0, thisKeyLength);
        }
        return thisKey.compareTo(thatKey) == 0;
    }

    @Override
    public void print() {
        this.childNode.printItems();
    }

    public BPTreeNode getChildNode() {
        return this.childNode;
    }
}

