/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.broad.igv.bbfile.BPTreeLeafNodeItem;
import org.broad.igv.bbfile.BPTreeNode;
import org.broad.igv.bbfile.BPTreeNodeItem;

public class BPTreeLeafNode
implements BPTreeNode {
    private final boolean isLeafNode = true;
    private final long nodeIndex;
    String lowestChromKey;
    String highestChromKey;
    int lowestChromID;
    int highestChromID;
    private final ArrayList<BPTreeLeafNodeItem> leafItems;

    public BPTreeLeafNode(long nodeIndex) {
        this.nodeIndex = nodeIndex;
        this.leafItems = new ArrayList();
    }

    @Override
    public long getNodeIndex() {
        return this.nodeIndex;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean insertItem(BPTreeNodeItem item) {
        this.leafItems.add((BPTreeLeafNodeItem)item);
        if (this.leafItems.size() == 1) {
            this.lowestChromKey = item.getChromKey();
            this.lowestChromID = ((BPTreeLeafNodeItem)item).getChromID();
        } else {
            this.highestChromKey = item.getChromKey();
            this.highestChromID = ((BPTreeLeafNodeItem)item).getChromID();
        }
        return true;
    }

    @Override
    public boolean deleteItem(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return false;
        }
        this.leafItems.remove(index);
        return true;
    }

    @Override
    public int getItemCount() {
        return this.leafItems.size();
    }

    @Override
    public BPTreeNodeItem getItem(int index) {
        if (this.getItemCount() > 0 && index < this.getItemCount()) {
            return this.leafItems.get(index);
        }
        return null;
    }

    @Override
    public String getLowestChromKey() {
        if (this.leafItems.size() > 0) {
            return this.lowestChromKey;
        }
        return null;
    }

    @Override
    public String getHighestChromKey() {
        if (this.leafItems.size() > 0) {
            return this.highestChromKey;
        }
        return null;
    }

    @Override
    public int getLowestChromID() {
        if (this.leafItems.size() > 0) {
            return this.lowestChromID;
        }
        return -1;
    }

    @Override
    public int getHighestChromID() {
        if (this.leafItems.size() > 0) {
            return this.highestChromID;
        }
        return -1;
    }

    @Override
    public void printItems() {
        int itemCount = this.getItemCount();
        for (int item = 0; item < itemCount; ++item) {
            this.leafItems.get(item).print();
        }
    }

    public ArrayList<BPTreeLeafNodeItem> getLeafItems() {
        return this.leafItems;
    }
}

