/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.broad.igv.bbfile.BBCompressionUtils;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class BigBedDataBlock {
    private final SeekableStream fis;
    private final long fileOffset;
    private final long dataBlockSize;
    private final boolean isLowToHigh;
    private final HashMap<Integer, String> chromosomeMap;
    private final RPTreeLeafNodeItem leafHitItem;
    private final byte[] bedBuffer;
    private int remDataSize;
    private long dataSizeRead;
    private LittleEndianInputStream lbdis;
    private DataInputStream dis;
    private ArrayList<BedFeature> bedFeatureList;
    private int nItemsSelected;

    public BigBedDataBlock(SeekableStream fis, RPTreeLeafNodeItem leafHitItem, HashMap<Integer, String> chromosomeMap, boolean isLowToHigh, int uncompressBufSize) {
        this.fis = fis;
        this.leafHitItem = leafHitItem;
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.dataBlockSize = this.leafHitItem.geDataSize();
        byte[] buffer = new byte[(int)this.dataBlockSize];
        this.fileOffset = this.leafHitItem.getDataOffset();
        try {
            fis.seek(this.fileOffset);
            fis.readFully(buffer);
            this.bedBuffer = uncompressBufSize > 0 ? BBCompressionUtils.decompress(buffer, uncompressBufSize) : buffer;
        }
        catch (IOException ex) {
            String error = "Error reading Bed data for leaf item %d \n";
            throw new RuntimeException(error, ex);
        }
        if (this.isLowToHigh) {
            this.lbdis = new LittleEndianInputStream(new ByteArrayInputStream(this.bedBuffer));
        } else {
            this.dis = new DataInputStream(new ByteArrayInputStream(this.bedBuffer));
        }
        this.remDataSize = this.bedBuffer.length;
    }

    public ArrayList<BedFeature> getBedData(RPChromosomeRegion selectionRegion, boolean contained) {
        block8: {
            int itemNumber = 0;
            int minItemSize = 13;
            this.bedFeatureList = new ArrayList();
            RPChromosomeRegion itemRegion = new RPChromosomeRegion(this.leafHitItem.getChromosomeBounds());
            int leafHitValue = itemRegion.compareRegions(selectionRegion);
            try {
                int index = 0;
                while (this.remDataSize > 0) {
                    BedFeature bbItem;
                    String chromosome;
                    String restOfFields;
                    int chromEnd;
                    int chromStart;
                    int chromID;
                    itemNumber = index + 1;
                    if (this.isLowToHigh) {
                        chromID = this.lbdis.readInt();
                        chromStart = this.lbdis.readInt();
                        chromEnd = this.lbdis.readInt();
                        restOfFields = this.lbdis.readString();
                    } else {
                        chromID = this.dis.readInt();
                        chromStart = this.dis.readInt();
                        chromEnd = this.dis.readInt();
                        restOfFields = this.dis.readUTF();
                    }
                    if (leafHitValue == 0) {
                        chromosome = this.chromosomeMap.get(chromID);
                        bbItem = new BedFeature(itemNumber, chromosome, chromStart, chromEnd, restOfFields);
                        this.bedFeatureList.add(bbItem);
                    } else {
                        itemRegion = new RPChromosomeRegion(chromID, chromStart, chromID, chromEnd);
                        int itemHitValue = itemRegion.compareRegions(selectionRegion);
                        if (!contained && Math.abs(itemHitValue) < 2 || itemHitValue == 0) {
                            chromosome = this.chromosomeMap.get(chromID);
                            bbItem = new BedFeature(itemNumber, chromosome, chromStart, chromEnd, restOfFields);
                            this.bedFeatureList.add(bbItem);
                        }
                    }
                    this.remDataSize -= minItemSize + restOfFields.length();
                    ++index;
                }
            }
            catch (IOException ex) {
                if (itemNumber != true) break block8;
                throw new RuntimeException("Read error for Bed data item " + itemNumber);
            }
        }
        return this.bedFeatureList;
    }

    public void print() {
        for (int index = 0; index <= this.bedFeatureList.size(); ++index) {
            this.bedFeatureList.get(index).print();
        }
    }
}

