/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.broad.igv.bbfile.BBCompressionUtils;
import org.broad.igv.bbfile.BigWigSection;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.WigItem;
import org.broad.tribble.util.SeekableStream;

public class BigWigDataBlock {
    final int FIXED_STEP_ITEM_SIZE = 4;
    final int VAR_STEP_ITEM_SIZE = 8;
    final int BED_GRAPH_ITEM_SIZE = 12;
    private final long fileOffset;
    private final long leafDataSize;
    private final boolean isLowToHigh;
    private final HashMap<Integer, String> chromosomeMap;
    private final RPTreeLeafNodeItem leafHitItem;
    private final byte[] wigBuffer;
    private int remDataSize;
    private ArrayList<WigItem> wigItemList;

    public BigWigDataBlock(SeekableStream fis, RPTreeLeafNodeItem leafHitItem, HashMap<Integer, String> chromosomeMap, boolean isLowToHigh, int uncompressBufSize) {
        this.leafHitItem = leafHitItem;
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.fileOffset = this.leafHitItem.getDataOffset();
        this.leafDataSize = this.leafHitItem.geDataSize();
        byte[] buffer = new byte[(int)this.leafDataSize];
        try {
            fis.seek(this.fileOffset);
            fis.readFully(buffer);
            this.wigBuffer = uncompressBufSize > 0 ? BBCompressionUtils.decompress(buffer, uncompressBufSize) : buffer;
        }
        catch (IOException ex) {
            String error = "Error reading Wig section for leaf item %d\n";
            throw new RuntimeException(error, ex);
        }
        this.remDataSize = this.wigBuffer.length;
    }

    public ArrayList<WigItem> getWigData(RPChromosomeRegion selectionRegion, boolean contained) {
        this.wigItemList = new ArrayList();
        int index = 0;
        while (this.remDataSize > 0) {
            BigWigSection wigSection = new BigWigSection(this.wigBuffer, this.chromosomeMap, this.isLowToHigh, this.leafHitItem);
            int sectionBytes = wigSection.getSectionData(selectionRegion, contained, this.wigItemList);
            this.remDataSize -= sectionBytes;
            ++index;
        }
        return this.wigItemList;
    }

    public void print() {
        for (int index = 0; index <= this.wigItemList.size(); ++index) {
            this.wigItemList.get(index).print();
        }
    }
}

