/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.broad.tribble.util.LittleEndianInputStream;

public class BigWigSectionHeader {
    public static final int SECTION_HEADER_SIZE = 24;
    public static final int FIXEDSTEP_ITEM_SIZE = 4;
    public static final int VARSTEP_ITEM_SIZE = 8;
    public static final int BEDGRAPH_ITEM_SIZE = 12;
    private final int chromID;
    private final int chromStart;
    private final int chromEnd;
    private final int itemStep;
    private final int itemSpan;
    private WigItemType itemType;
    private final byte reserved;
    private final short itemCount;
    private final boolean isValidType;
    private String itemDescription;

    public BigWigSectionHeader(LittleEndianInputStream lbdis) {
        byte type;
        try {
            this.chromID = lbdis.readInt();
            this.chromStart = lbdis.readInt();
            this.chromEnd = lbdis.readInt();
            this.itemStep = lbdis.readInt();
            this.itemSpan = lbdis.readInt();
            type = lbdis.readByte();
            this.reserved = lbdis.readByte();
            this.itemCount = lbdis.readShort();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading wig section header", ex);
        }
        this.isValidType = this.getItemType(type);
    }

    public BigWigSectionHeader(DataInputStream bdis) {
        byte type;
        try {
            this.chromID = bdis.readInt();
            this.chromStart = bdis.readInt();
            this.chromEnd = bdis.readInt();
            this.itemStep = bdis.readInt();
            this.itemSpan = bdis.readInt();
            type = bdis.readByte();
            this.reserved = bdis.readByte();
            this.itemCount = bdis.readShort();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error reading wig section header", ex);
        }
        this.isValidType = this.getItemType(type);
    }

    public int getChromID() {
        return this.chromID;
    }

    public int getChromosomeStart() {
        return this.chromStart;
    }

    public int getChromosomeEnd() {
        return this.chromEnd;
    }

    public int getItemStep() {
        return this.itemStep;
    }

    public int getItemSpan() {
        return this.itemSpan;
    }

    public WigItemType getItemType() {
        return this.itemType;
    }

    public boolean IsValidType() {
        return this.isValidType;
    }

    public short getItemCount() {
        return this.itemCount;
    }

    public byte getReserved() {
        return this.reserved;
    }

    private boolean getItemType(byte type) {
        boolean isValid;
        if (type == 1) {
            this.itemType = WigItemType.BedGraph;
            this.itemDescription = "Wig Bed Graph";
            isValid = true;
        } else if (type == 2) {
            this.itemType = WigItemType.VarStep;
            this.itemDescription = "Wig Variable Step";
            isValid = true;
        } else if (type == 3) {
            this.itemType = WigItemType.FixedStep;
            this.itemDescription = "Wig Fixed Step";
            isValid = true;
        } else {
            this.itemType = WigItemType.Unknown;
            this.itemDescription = "Wig Type Unknown";
            isValid = false;
        }
        return isValid;
    }

    public static enum WigItemType {
        BedGraph,
        VarStep,
        FixedStep,
        Unknown;

    }
}

