/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeChildNodeItem;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;

public class RPTreeChildNode
implements RPTreeNode {
    private RPChromosomeRegion chromosomeBounds;
    private final ArrayList<RPTreeChildNodeItem> childItems = new ArrayList();

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    @Override
    public int compareRegions(RPChromosomeRegion chromosomeRegion) {
        int value = this.chromosomeBounds.compareRegions(chromosomeRegion);
        return value;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public int getItemCount() {
        return this.childItems.size();
    }

    @Override
    public RPTreeNodeItem getItem(int index) {
        if (index < 0 || index >= this.childItems.size()) {
            return null;
        }
        RPTreeChildNodeItem item = this.childItems.get(index);
        return item;
    }

    @Override
    public boolean insertItem(RPTreeNodeItem item) {
        RPTreeChildNodeItem newItem = (RPTreeChildNodeItem)item;
        this.childItems.add(newItem);
        this.chromosomeBounds = this.chromosomeBounds == null ? new RPChromosomeRegion(newItem.getChromosomeBounds()) : this.chromosomeBounds.getExtremes(newItem.getChromosomeBounds());
        return true;
    }

    @Override
    public boolean deleteItem(int index) {
        int itemCount = this.getItemCount();
        if (index < 0 || index >= itemCount) {
            return false;
        }
        this.childItems.remove(index);
        return true;
    }

    @Override
    public void printItems() {
        for (int item = 0; item < this.childItems.size(); ++item) {
            this.childItems.get(item).print();
        }
    }
}

