/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;
import org.broad.igv.bbfile.RPTreeNodeProxy;

public class RPTreeChildNodeItem
implements RPTreeNodeItem {
    private final RPChromosomeRegion chromosomeBounds;
    private RPTreeNode childNode;

    public RPTreeChildNodeItem(int startChromID, int startBase, int endChromID, int endBase, RPTreeNode childNode) {
        this.chromosomeBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        this.childNode = childNode;
    }

    public RPTreeChildNodeItem(int startChromID, int startBase, int endChromID, int endBase, long childDataOffset) {
        this.chromosomeBounds = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
    }

    @Override
    public RPChromosomeRegion getChromosomeBounds() {
        return this.chromosomeBounds;
    }

    public RPTreeNode getChildNode() {
        if (this.childNode instanceof RPTreeNodeProxy) {
            RPTreeNodeProxy proxy = (RPTreeNodeProxy)this.childNode;
            this.childNode = RPTree.readRPTreeNode(proxy.fis, proxy.fileOffset, proxy.isLowToHigh, true);
        }
        return this.childNode;
    }

    @Override
    public int compareRegions(RPChromosomeRegion chromosomeRegion) {
        int value = this.chromosomeBounds.compareRegions(chromosomeRegion);
        return value;
    }

    @Override
    public void print() {
        this.childNode.printItems();
    }
}

