/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.broad.igv.bbfile.BBCompressionUtils;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.igv.bbfile.ZoomDataRecord;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.SeekableStream;

public class ZoomDataBlock {
    private final long fileOffset;
    private final long dataBlockSize;
    private final boolean isLowToHigh;
    private final int zoomLevel;
    private final HashMap<Integer, String> chromosomeMap;
    private final RPTreeLeafNodeItem leafHitItem;
    private final byte[] zoomBuffer;
    private int remDataSize;
    private LittleEndianInputStream lbdis = null;
    private DataInputStream dis = null;
    private ArrayList<ZoomDataRecord> zoomDataList;

    public ZoomDataBlock(int zoomLevel, SeekableStream fis, RPTreeLeafNodeItem leafHitItem, HashMap<Integer, String> chromosomeMap, boolean isLowToHigh, int uncompressBufSize) {
        this.zoomLevel = zoomLevel;
        this.leafHitItem = leafHitItem;
        this.chromosomeMap = chromosomeMap;
        this.isLowToHigh = isLowToHigh;
        this.fileOffset = this.leafHitItem.getDataOffset();
        this.dataBlockSize = this.leafHitItem.geDataSize();
        byte[] buffer = new byte[(int)this.dataBlockSize];
        try {
            fis.seek(this.fileOffset);
            fis.readFully(buffer);
            this.zoomBuffer = uncompressBufSize > 0 ? BBCompressionUtils.decompress(buffer, uncompressBufSize) : buffer;
        }
        catch (IOException ex) {
            String error = String.format("Error reading zoom level %d data for leaf item %d\n", this.zoomLevel);
            throw new RuntimeException(error, ex);
        }
        if (this.isLowToHigh) {
            this.lbdis = new LittleEndianInputStream(new ByteArrayInputStream(this.zoomBuffer));
        } else {
            this.dis = new DataInputStream(new ByteArrayInputStream(this.zoomBuffer));
        }
        this.remDataSize = this.zoomBuffer.length;
    }

    public ArrayList<ZoomDataRecord> getZoomData(RPChromosomeRegion selectionRegion, boolean contained) {
        block8: {
            int recordNumber = 0;
            this.zoomDataList = new ArrayList();
            RPChromosomeRegion itemRegion = new RPChromosomeRegion(this.leafHitItem.getChromosomeBounds());
            int leafHitValue = itemRegion.compareRegions(selectionRegion);
            try {
                int index = 0;
                while (this.remDataSize > 0) {
                    ZoomDataRecord zoomRecord;
                    String chromName;
                    float sumSquares;
                    float sumData;
                    float maxVal;
                    float minVal;
                    int validCount;
                    int chromEnd;
                    int chromStart;
                    int chromID;
                    recordNumber = index + 1;
                    if (this.isLowToHigh) {
                        chromID = this.lbdis.readInt();
                        chromStart = this.lbdis.readInt();
                        chromEnd = this.lbdis.readInt();
                        validCount = this.lbdis.readInt();
                        minVal = this.lbdis.readFloat();
                        maxVal = this.lbdis.readFloat();
                        sumData = this.lbdis.readFloat();
                        sumSquares = this.lbdis.readFloat();
                    } else {
                        chromID = this.dis.readInt();
                        chromStart = this.dis.readInt();
                        chromEnd = this.dis.readInt();
                        validCount = this.dis.readInt();
                        minVal = this.dis.readFloat();
                        maxVal = this.dis.readFloat();
                        sumData = this.dis.readFloat();
                        sumSquares = this.dis.readFloat();
                    }
                    if (leafHitValue == 0) {
                        chromName = this.chromosomeMap.get(chromID);
                        zoomRecord = new ZoomDataRecord(this.zoomLevel, recordNumber, chromName, chromID, chromStart, chromEnd, validCount, minVal, maxVal, sumData, sumSquares);
                        this.zoomDataList.add(zoomRecord);
                    } else {
                        itemRegion = new RPChromosomeRegion(chromID, chromStart, chromID, chromEnd);
                        int itemHitValue = itemRegion.compareRegions(selectionRegion);
                        if (!contained && Math.abs(itemHitValue) < 2 || itemHitValue == 0) {
                            chromName = this.chromosomeMap.get(chromID);
                            zoomRecord = new ZoomDataRecord(this.zoomLevel, recordNumber, chromName, chromID, chromStart, chromEnd, validCount, minVal, maxVal, sumData, sumSquares);
                            this.zoomDataList.add(zoomRecord);
                        }
                    }
                    this.remDataSize -= 32;
                    ++index;
                }
            }
            catch (IOException ex) {
                if (recordNumber != true) break block8;
                throw new RuntimeException("Read error for zoom level " + this.zoomLevel + " leaf item ");
            }
        }
        return this.zoomDataList;
    }
}

