/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

public class ZoomDataRecord {
    public static final int RECORD_SIZE = 32;
    private final int zoomLevel;
    private final int recordNumber;
    private final String chromName;
    private final int chromId;
    private final int chromStart;
    private final int chromEnd;
    private final int basesCovered;
    private final float minVal;
    private final float maxVal;
    private final float sumData;
    private final float sumSquares;

    public ZoomDataRecord(int zoomLevel, int recordNumber, String chromName, int chromId, int chromStart, int chromEnd, int validCount, float minVal, float maxVal, float sumData, float sumSquares) {
        this.zoomLevel = zoomLevel;
        this.recordNumber = recordNumber;
        this.chromName = chromName;
        this.chromId = chromId;
        this.chromStart = chromStart;
        this.chromEnd = chromEnd;
        this.basesCovered = validCount;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.sumData = sumData;
        this.sumSquares = sumSquares;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public String getChromName() {
        return this.chromName;
    }

    public int getChromId() {
        return this.chromId;
    }

    public int getChromStart() {
        return this.chromStart;
    }

    public int getChromEnd() {
        return this.chromEnd;
    }

    public int getBasesCovered() {
        return this.basesCovered;
    }

    public float getMinVal() {
        return this.minVal;
    }

    public float getMaxVal() {
        return this.maxVal;
    }

    public float getSumData() {
        return this.sumData;
    }

    public float getMeanVal() {
        return this.basesCovered == 0 ? 0.0f : this.sumData / (float)this.basesCovered;
    }

    public float getSumSquares() {
        return this.sumSquares;
    }
}

