/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.rosuda.REngine.REXP;

public class RList
extends Vector
implements List {
    public Vector names;

    public RList() {
        this.names = null;
    }

    public RList(REXP[] rEXPArray) {
        super(rEXPArray.length);
        int n = 0;
        while (n < rEXPArray.length) {
            super.add(rEXPArray[n++]);
        }
        this.names = null;
    }

    public RList(int n, boolean bl) {
        super(n);
        this.names = null;
        if (bl) {
            this.names = new Vector(n);
        }
    }

    public RList(Collection collection) {
        super(collection);
        this.names = null;
    }

    public RList(REXP[] rEXPArray, String[] stringArray) {
        this(rEXPArray);
        if (stringArray != null && stringArray.length > 0) {
            this.names = new Vector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.names.add(stringArray[n++]);
            }
            while (this.names.size() < this.size()) {
                this.names.add(null);
            }
        }
    }

    public RList(Collection collection, String[] stringArray) {
        this(collection);
        if (stringArray != null && stringArray.length > 0) {
            this.names = new Vector(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.names.add(stringArray[n++]);
            }
            while (this.names.size() < this.size()) {
                this.names.add(null);
            }
        }
    }

    public RList(Collection collection, Collection collection2) {
        this(collection);
        if (collection2 != null && collection2.size() > 0) {
            this.names = new Vector(collection2);
            while (this.names.size() < this.size()) {
                this.names.add(null);
            }
        }
    }

    public boolean isNamed() {
        return this.names != null;
    }

    public REXP at(String string) {
        if (this.names == null) {
            return null;
        }
        int n = this.names.indexOf(string);
        if (n < 0) {
            return null;
        }
        return (REXP)this.elementAt(n);
    }

    public REXP at(int n) {
        return n >= 0 && n < this.size() ? (REXP)this.elementAt(n) : null;
    }

    public String keyAt(int n) {
        return this.names == null || n < 0 || n >= this.names.size() ? null : (String)this.names.get(n);
    }

    public void setKeyAt(int n, String string) {
        if (n < 0) {
            return;
        }
        if (this.names == null) {
            this.names = new Vector();
        }
        if (this.names.size() < this.size()) {
            this.names.setSize(this.size());
        }
        if (n < this.size()) {
            this.names.set(n, string);
        }
    }

    public String[] keys() {
        if (this.names == null) {
            return null;
        }
        String[] stringArray = new String[this.names.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.keyAt(i);
        }
        return stringArray;
    }

    public void add(int n, Object object) {
        super.add(n, object);
        if (this.names == null) {
            return;
        }
        this.names.add(n, null);
    }

    public boolean add(Object object) {
        super.add(object);
        if (this.names != null) {
            this.names.add(null);
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl = super.addAll(collection);
        if (this.names == null) {
            return bl;
        }
        int n = this.size();
        while (this.names.size() < n) {
            this.names.add(null);
        }
        return bl;
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = super.addAll(n, collection);
        if (this.names == null) {
            return bl;
        }
        int n2 = collection.size();
        while (n2-- > 0) {
            this.names.add(n, null);
        }
        return bl;
    }

    public void clear() {
        super.clear();
        this.names = null;
    }

    public Object clone() {
        return new RList((Collection)this, this.names);
    }

    public Object remove(int n) {
        Object e = super.remove(n);
        if (this.names != null) {
            this.names.remove(n);
            if (this.size() == 0) {
                this.names = null;
            }
        }
        return e;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n < 0) {
            return false;
        }
        this.remove(n);
        if (this.size() == 0) {
            this.names = null;
        }
        return true;
    }

    public boolean removeAll(Collection collection) {
        if (this.names == null) {
            return super.removeAll(collection);
        }
        boolean bl = false;
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            bl |= this.remove(iterator2.next());
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        int n;
        if (this.names == null) {
            return super.retainAll(collection);
        }
        boolean[] blArray = new boolean[this.size()];
        boolean bl = false;
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = !collection.contains(this.get(n));
            bl |= blArray[n];
        }
        while (n > 0) {
            if (!blArray[--n]) continue;
            this.remove(n);
        }
        return bl;
    }

    public void removeAllElements() {
        this.clear();
    }

    public void insertElementAt(Object object, int n) {
        this.add(n, object);
    }

    public void addElement(Object object) {
        this.add(object);
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    public boolean removeElement(Object object) {
        return this.remove(object);
    }

    public boolean containsKey(Object object) {
        return this.names == null ? false : this.names.contains(object);
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public Set entrySet() {
        return null;
    }

    public Object get(Object object) {
        return this.at((String)object);
    }

    public Set keySet() {
        if (this.names == null) {
            return null;
        }
        return new HashSet(this.names);
    }

    public Object put(Object object, Object object2) {
        int n;
        if (object == null) {
            this.add(object2);
            return null;
        }
        if (this.names != null && (n = this.names.indexOf(object)) >= 0) {
            return super.set(n, object2);
        }
        n = this.size();
        super.add(object2);
        if (this.names == null) {
            this.names = new Vector(n + 1);
        }
        while (this.names.size() < n) {
            this.names.add(null);
        }
        this.names.add(object);
        return null;
    }

    public void putAll(Map map) {
        if (map == null) {
            return;
        }
        if (map instanceof RList) {
            RList rList = (RList)((Object)map);
            if (this.names == null) {
                this.addAll((Collection)rList);
                return;
            }
            int n = rList.size();
            for (int i = 0; i < n; ++i) {
                String string = rList.keyAt(i);
                if (string == null) {
                    this.add(rList.at(i));
                    continue;
                }
                this.put(string, rList.at(i));
            }
        } else {
            Set set = map.keySet();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Object k = iterator2.next();
                this.put(k, map.get(k));
            }
        }
    }

    public void putAll(RList rList) {
        if (rList == null) {
            return;
        }
        RList rList2 = rList;
        if (this.names == null) {
            this.addAll((Collection)rList2);
            return;
        }
        int n = rList2.size();
        for (int i = 0; i < n; ++i) {
            String string = rList2.keyAt(i);
            if (string == null) {
                this.add(rList2.at(i));
                continue;
            }
            this.put(string, rList2.at(i));
        }
    }

    public Object removeByKey(Object object) {
        if (this.names == null) {
            return null;
        }
        int n = this.names.indexOf(object);
        if (n < 0) {
            return null;
        }
        Object e = this.elementAt(n);
        this.removeElementAt(n);
        this.names.removeElementAt(n);
        return e;
    }

    public Collection values() {
        return this;
    }

    public String toString() {
        return "RList" + super.toString() + "{" + (this.isNamed() ? "named," : "") + this.size() + "}";
    }
}

