/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.charts;

import cern.colt.list.DoubleArrayList;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.Formatter;
import java.util.Locale;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import umontreal.iro.lecuyer.charts.Axis;
import umontreal.iro.lecuyer.charts.XYChart;
import umontreal.iro.lecuyer.charts.XYListSeriesCollection;

public class XYLineChart
extends XYChart {
    protected void init(String title, String XLabel, String YLabel) {
        this.chart = ChartFactory.createXYLineChart((String)title, (String)XLabel, (String)YLabel, (XYDataset)this.dataset.getSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        if (null != title && (title.startsWith("cdf") || title.startsWith("prob") || title.startsWith("density"))) {
            this.setprobFlag(true);
        }
        ((XYPlot)this.chart.getPlot()).setRenderer(this.dataset.getRenderer());
        this.initAxis();
    }

    protected void initAxis() {
        this.XAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getDomainAxis(), true);
        this.YAxis = new Axis((NumberAxis)((XYPlot)this.chart.getPlot()).getRangeAxis(), false);
        this.setAutoRange(true, true);
    }

    public XYLineChart() {
        this.dataset = new XYListSeriesCollection();
        this.init(null, null, null);
    }

    public XYLineChart(String title, String XLabel, String YLabel, double[][] ... data) {
        this.dataset = new XYListSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public XYLineChart(String title, String XLabel, String YLabel, double[][] data, int numPoints) {
        this.dataset = new XYListSeriesCollection(data, numPoints);
        this.init(title, XLabel, YLabel);
    }

    public XYLineChart(String title, String XLabel, String YLabel, double[][] data, int x, int y) {
        int len = data[0].length;
        double[][] proj = new double[2][len];
        for (int i = 0; i < len; ++i) {
            proj[0][i] = data[x][i];
            proj[1][i] = data[y][i];
        }
        this.dataset = new XYListSeriesCollection(new double[][][]{proj});
        this.init(title, XLabel, YLabel);
    }

    public XYLineChart(String title, String XLabel, String YLabel, DoubleArrayList ... data) {
        this.dataset = new XYListSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public XYLineChart(String title, String XLabel, String YLabel, XYSeriesCollection data) {
        this.dataset = new XYListSeriesCollection(data);
        this.init(title, XLabel, YLabel);
    }

    public int add(double[] x, double[] y, String name, String plotStyle) {
        int seriesIndex = this.add(x, y);
        this.getSeriesCollection().setName(seriesIndex, name);
        this.getSeriesCollection().setPlotStyle(seriesIndex, plotStyle);
        return seriesIndex;
    }

    public int add(double[] x, double[] y) {
        int seriesIndex = this.getSeriesCollection().add(x, y);
        this.initAxis();
        return seriesIndex;
    }

    public int add(double[] x, double[] y, int numPoints) {
        int seriesIndex = this.getSeriesCollection().add(x, y, numPoints);
        this.initAxis();
        return seriesIndex;
    }

    public int add(double[][] data) {
        int seriesIndex = this.getSeriesCollection().add(data);
        this.initAxis();
        return seriesIndex;
    }

    public int add(double[][] data, int numPoints) {
        int seriesIndex = this.getSeriesCollection().add(data, numPoints);
        this.initAxis();
        return seriesIndex;
    }

    public XYListSeriesCollection getSeriesCollection() {
        return (XYListSeriesCollection)this.dataset;
    }

    public void setSeriesCollection(XYListSeriesCollection dataset) {
        this.dataset = dataset;
    }

    public void setTicksSynchro(int s) {
        XYSeriesCollection seriesCollection = (XYSeriesCollection)this.dataset.getSeriesCollection();
        double[] values2 = new double[seriesCollection.getItemCount(s)];
        for (int i = 0; i < seriesCollection.getItemCount(s); ++i) {
            values2[i] = seriesCollection.getXValue(s, i);
        }
        this.XAxis.setLabels(values2);
    }

    public JFrame view(int width, int height) {
        JFrame myFrame = this.chart.getTitle() != null ? new JFrame("XYLineChart from SSJ: " + this.chart.getTitle().getText()) : new JFrame("XYLineChart from SSJ");
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(width, height));
        myFrame.setContentPane((Container)chartPanel);
        myFrame.pack();
        myFrame.setDefaultCloseOperation(2);
        myFrame.setLocationRelativeTo(null);
        myFrame.setVisible(true);
        return myFrame;
    }

    public JFrame viewBar(int width, int height) {
        JFrame myFrame = this.chart.getTitle() != null ? new JFrame("XYLineChart from SSJ: " + this.chart.getTitle().getText()) : new JFrame("XYLineChart from SSJ");
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setDataset(0, this.dataset.getSeriesCollection());
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(false, true);
        renderer.setSeriesPaint(0, (Paint)Color.ORANGE);
        renderer.setSeriesShape(0, (Shape)new Line2D.Double(0.0, 0.0, 0.0, 1000.0));
        plot.setRenderer(0, (XYItemRenderer)renderer);
        plot.setDataset(1, this.dataset.getSeriesCollection());
        XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(false, true);
        renderer2.setSeriesPaint(0, (Paint)Color.ORANGE);
        renderer2.setSeriesShape(0, (Shape)new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0));
        plot.setRenderer(1, (XYItemRenderer)renderer2);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(width, height));
        myFrame.setContentPane((Container)chartPanel);
        myFrame.pack();
        myFrame.setDefaultCloseOperation(2);
        myFrame.setLocationRelativeTo(null);
        myFrame.setVisible(true);
        return myFrame;
    }

    public String toLatex(double width, double height) {
        double xunit = 0.0;
        double yunit = 0.0;
        double[] save = new double[4];
        if (this.dataset.getSeriesCollection().getSeriesCount() == 0) {
            throw new IllegalArgumentException("Empty chart");
        }
        double XScale = this.computeXScale(this.XAxis.getTwinAxisPosition());
        double YScale = this.computeYScale(this.YAxis.getTwinAxisPosition());
        xunit = width / (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) * XScale - Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) * XScale);
        yunit = height / (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) * YScale - Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) * YScale);
        Formatter formatter = new Formatter(Locale.US);
        if (this.latexDocFlag) {
            formatter.format("\\documentclass[12pt]{article}%n%n", new Object[0]);
            formatter.format("\\usepackage{tikz}%n\\usetikzlibrary{plotmarks}%n\\begin{document}%n%n", new Object[0]);
        }
        if (this.chart.getTitle() != null) {
            formatter.format("%% PGF/TikZ picture from SSJ: %s%n", this.chart.getTitle().getText());
        } else {
            formatter.format("%% PGF/TikZ picture from SSJ %n", new Object[0]);
        }
        formatter.format("%% XScale = %s,  YScale = %s,  XShift = %s,  YShift = %s%n", XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition());
        formatter.format("%% Therefore, thisFileXValue = (originalSeriesXValue+XShift)*XScale%n", new Object[0]);
        formatter.format("%%        and thisFileYValue = (originalSeriesYValue+YShift)*YScale%n%n", new Object[0]);
        if (this.chart.getTitle() != null) {
            formatter.format("\\begin{figure}%n", new Object[0]);
        }
        formatter.format("\\begin{center}%n", new Object[0]);
        formatter.format("\\begin{tikzpicture}[x=%scm, y=%scm]%n", xunit, yunit);
        formatter.format("\\footnotesize%n", new Object[0]);
        if (this.grid) {
            formatter.format("\\draw[color=lightgray] (%s, %s) grid[xstep = %s, ystep=%s] (%s, %s);%n", (Math.min(this.XAxis.getAxis().getRange().getLowerBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.min(this.YAxis.getAxis().getRange().getLowerBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale, this.xstepGrid * XScale, this.ystepGrid * YScale, (Math.max(this.XAxis.getAxis().getRange().getUpperBound(), this.XAxis.getTwinAxisPosition()) - this.XAxis.getTwinAxisPosition()) * XScale, (Math.max(this.YAxis.getAxis().getRange().getUpperBound(), this.YAxis.getTwinAxisPosition()) - this.YAxis.getTwinAxisPosition()) * YScale);
        }
        this.setTick0Flags();
        formatter.format("%s", this.XAxis.toLatex(XScale));
        formatter.format("%s", this.YAxis.toLatex(YScale));
        formatter.format("%s", this.dataset.toLatex(XScale, YScale, this.XAxis.getTwinAxisPosition(), this.YAxis.getTwinAxisPosition(), this.XAxis.getAxis().getLowerBound(), this.XAxis.getAxis().getUpperBound(), this.YAxis.getAxis().getLowerBound(), this.YAxis.getAxis().getUpperBound()));
        formatter.format("\\end{tikzpicture}%n", new Object[0]);
        formatter.format("\\end{center}%n", new Object[0]);
        if (this.chart.getTitle() != null) {
            formatter.format("\\caption{", new Object[0]);
            formatter.format(this.chart.getTitle().getText(), new Object[0]);
            formatter.format("}%n\\end{figure}%n", new Object[0]);
        }
        if (this.latexDocFlag) {
            formatter.format("\\end{document}%n", new Object[0]);
        }
        return formatter.toString();
    }
}

